<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
/**
Plugin Name: Portfolio Filter Gallery Premium
Plugin URI: http://awplife.com/
Description: The most populor Portfolio Filter Gallery Premium plugin for Wordpress.
Version: 6.8
Author: A WP Life
Author URI: http://awplife.com/
License: GPLv2 or later
Text Domain: portfolio-filter-gallery
Domain Path: /languages
**/
if ( ! class_exists( 'Awl_Portfolio_Filter_Gallery' ) ) {
	class Awl_Portfolio_Filter_Gallery {
		public function __construct() {
			$this->_constants();
			$this->_hooks();
		}
		protected function _constants() {
			//Plugin Version
			define( 'PFG_PLUGIN_VER', '6.8' );
			//Plugin Text Domain
			define("'portfolio-filter-gallery'","awl-portfolio-filter-gallery" );
			//Plugin Name
			define( 'PFG_PLUGIN_NAME', __( 'Portfolio Filter Gallery Premium', 'portfolio-filter-gallery' ) );
			//Plugin Slug
			define( 'PFG_PLUGIN_SLUG', 'awl_filter_gallery' );
			//Plugin Directory Path
			define( 'PFG_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
			//Plugin Directory URL
			define( 'PFG_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
			define( 'PFG_SECURE_KEY', md5( NONCE_KEY ) );
		} // end of constructor function
		
		protected function _hooks() {
			//Load text domain
			add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );
			//add gallery menu item, change menu filter for multisite
			add_action( 'admin_menu', array( $this, 'pfg_menu' ), 101 );
			//Create Portfolio Filter Gallery Custom Post
			add_action( 'init', array( $this, 'Portfolio_Filter_Gallery' ));
			//Add meta box to custom post
			add_action( 'add_meta_boxes', array( $this, 'admin_add_meta_box' ) );
			//loaded during admin init 
			add_action( 'admin_init', array( $this, 'admin_add_meta_box' ) );
			add_action('wp_ajax_pfg_gallery_js', array(&$this, '_ajax_pfg_gallery'));
			add_action('save_post', array(&$this, '_pfg_save_settings'));
			//Shortcode Compatibility in Text Widgets
			add_filter('widget_text', 'do_shortcode');
			// image cropping function
			add_image_size('thumb_300_x_300', 300, 300, true );
			add_image_size('thumb_500_x_500', 500, 500, true );
			// add pfg cpt shortcode column - manage_{$post_type}_posts_columns
			add_filter( 'manage_awl_filter_gallery_posts_columns', array(&$this, 'set_filter_gallery_shortcode_column_name') );
			// add pfg cpt shortcode column data - manage_{$post_type}_posts_custom_column
			add_action( 'manage_awl_filter_gallery_posts_custom_column' , array(&$this, 'custom_filter_gallery_shodrcode_data'), 10, 2 );
			add_action( 'wp_enqueue_scripts', array(&$this, 'enqueue_scripts_in_header') );
			
			//clone gallery ajax call back, its required localize ajax object
			add_action('wp_ajax_pfg_clone_gallery', array(&$this, 'pfg_clone_gallery'));
			
			add_filter( 'wp_lazy_loading_enabled', '__return_false' );
			
		}// end of hook function
	
	/**
	 * Clone slider call back
	 */
	public function pfg_clone_gallery() {
		if(isset($_POST['pfg_clone_post_id'])) {
			
			$pfg_clone_post_id = sanitize_text_field($_POST['pfg_clone_post_id']);
			// get all required data for cloning
			$post_title = get_the_title($pfg_clone_post_id)." - Duplicate";
			$post_type = "awl_filter_gallery";
			$post_status = "draft";
			
			// get slider post meta settings for cloning
			$PFG_Gallery_Settings_Key = "awl_filter_gallery".$pfg_clone_post_id;
			$PFG_Gallery_Settings = get_post_meta( $pfg_clone_post_id, $PFG_Gallery_Settings_Key, true);
			
			//cloning post
			$pfg_cloning_post_array =  array(
				'post_title' => $post_title,
				'post_type' => $post_type,
				'post_status' => $post_status,
				
			);
			
			$pfg_cloned_post_id = wp_insert_post($pfg_cloning_post_array);
			// images post meta settings cloning
			add_post_meta( $pfg_cloned_post_id, "awl_filter_gallery".$pfg_cloned_post_id, $PFG_Gallery_Settings);
			
		}
	}
		
		public function enqueue_scripts_in_header() {
			wp_enqueue_script('jquery');
		}
		
		// Filter gallery cpt shortcode column before date columns
		public function set_filter_gallery_shortcode_column_name($defaults) {
			$new = array();
			unset($defaults['tags']);	// remove it from the columns list
			foreach($defaults as $key=>$value) {
				if($key=='date') {  // when we find the date column
				   $new['_filter_gallery_shortcode'] = __( 'Shortcode', 'portfolio-filter-gallery' );  // put the tags column before it
				   $new['_filter_gallery_duplicate'] = __( 'Duplicate', 'portfolio-filter-gallery' );  // put the tags column before it
				}
				$new[$key] = $value;
			}
			return $new;  
		}
		
		// Filter gallery cpt shortcode column data
		public function custom_filter_gallery_shodrcode_data( $column, $post_id ) {
			switch ( $column ) {
				case '_filter_gallery_shortcode' :
					echo "<input type='text' class='button button-primary' id='filter-gallery-shortcode-$post_id' value='[PFG id=$post_id]' style='font-weight:bold; background-color:#32373C; color:#FFFFFF; text-align:center;' />";
					echo "<input type='button' class='button button-primary' onclick='return FilterCopyShortcode$post_id();' readonly value='Copy' style='margin-left:4px;' />";
					echo "<span id='copy-msg-$post_id' class='button button-primary' style='display:none; background-color:#32CD32; color:#FFFFFF; margin-left:4px; border-radius: 4px;'>copied</span>";
					echo "<script>
						function FilterCopyShortcode$post_id() {
							var copyText = document.getElementById('filter-gallery-shortcode-$post_id');
							copyText.select();
							document.execCommand('copy');
							//fade in and out copied message
							jQuery('#copy-msg-$post_id').fadeIn('1000', 'linear');
							jQuery('#copy-msg-$post_id').fadeOut(2500,'swing');
						}
						</script>
					";
				break;
				case '_filter_gallery_duplicate' :
					echo "<input type='button' class='button button-primary' onclick='return pfg_clone_run_$post_id($post_id);' readonly value='Duplicate Gallery' style='margin-left:4px;' />";
					echo "<script>
						function pfg_clone_run_$post_id(post_id){
							if(confirm('Do you want to duplicate this gallery?')){
								var formData = {
									'action': 'pfg_clone_gallery',
									'pfg_clone_post_id': post_id,
								};
								jQuery.ajax({
									type: 'post',
									dataType: 'json',
									url: ajaxurl,
									data: formData,
									success: function(response){
										
										location.href = 'edit.php?post_type=awl_filter_gallery';
									}
								});
							}
						}
						</script>
					";
				break;
				
			}
		}
		
		public function load_textdomain() {
			load_plugin_textdomain( 'portfolio-filter-gallery', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
		}
		
		public function pfg_menu() {
			// hide the update setting menu once the porcess done ((1 = show, 2 = hide))
			$old_setting_update_status = get_option('pfg_old_settings_updated', 1); // porcess check
			$pfg_hide_notice = get_option('pfg_hide_notice', 1); // hide notice
			if($old_setting_update_status == 1 && $pfg_hide_notice == 1) {
				$update_old_settings_menu = add_submenu_page( 'edit.php?post_type='.PFG_PLUGIN_SLUG, __( 'Update Old Settings', 'portfolio-filter-gallery' ), __( 'Update Old Settings', 'portfolio-filter-gallery' ), 'administrator', 'pfg-update-plugin', array( $this, 'update_old_settings_page') );
			}
			$filter_menu = add_submenu_page( 'edit.php?post_type='.PFG_PLUGIN_SLUG, __( 'Filters', 'portfolio-filter-gallery' ), __( 'Filters', 'portfolio-filter-gallery' ), 'administrator', 'pfg-filter-page', array( $this, 'awl_filter_page') );
			$doc_menu    = add_submenu_page( 'edit.php?post_type='.PFG_PLUGIN_SLUG, __( 'Docs', 'portfolio-filter-gallery' ), __( 'Docs', 'portfolio-filter-gallery' ), 'administrator', 'pfg-doc-page', array( $this, 'pfg_doc_page') );
		}
		
		public function Portfolio_Filter_Gallery() {
			$labels = array(
				'name'                => _x( 'Portfolio Filter Gallery', 'Post Type General Name', 'portfolio-filter-gallery' ),
				'singular_name'       => _x( 'Portfolio Filter Gallery', 'Post Type Singular Name', 'portfolio-filter-gallery' ),
				'menu_name'           => __( 'Portfolio Filter Gallery Premium', 'portfolio-filter-gallery' ),
				'name_admin_bar'      => __( 'Portfolio Filter', 'portfolio-filter-gallery' ),
				'parent_item_colon'   => __( 'Parent Item:', 'portfolio-filter-gallery' ),
				'all_items'           => __( 'All Gallery', 'portfolio-filter-gallery' ),
				'add_new_item'        => __( 'Add New Gallery', 'portfolio-filter-gallery' ),
				'add_new'             => __( 'Add New Gallery', 'portfolio-filter-gallery' ),
				'new_item'            => __( 'New Portfolio Filter Gallery', 'portfolio-filter-gallery' ),
				'edit_item'           => __( 'Edit Portfolio Filter Gallery', 'portfolio-filter-gallery' ),
				'update_item'         => __( 'Update Portfolio Filter Gallery', 'portfolio-filter-gallery' ),
				'search_items'        => __( 'Search Portfolio Filter Gallery', 'portfolio-filter-gallery' ),
				'not_found'           => __( 'Portfolio Filter Gallery Not found', 'portfolio-filter-gallery' ),
				'not_found_in_trash'  => __( 'Portfolio Filter Gallery Not found in Trash', 'portfolio-filter-gallery' ),
			);
			$args = array(
				'label'               => __( 'Portfolio Filter Gallery', 'portfolio-filter-gallery' ),
				'description'         => __( 'Custom Post Type For Portfolio Filter Gallery', 'portfolio-filter-gallery' ),
				'labels'              => $labels,
				'supports'            => array('title','revisions'),
				'taxonomies'          => array(),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
				'show_in_menu'        => true,
				'menu_position'       => 65,
				'menu_icon'           => 'dashicons-screenoptions',
				'show_in_admin_bar'   => true,
				'show_in_nav_menus'   => true,
				'can_export'          => true,
				'has_archive'         => true,
				'exclude_from_search' => false,
				'publicly_queryable'  => true,
				'capability_type'     => 'page',
			);
			register_post_type( 'awl_filter_gallery', $args );
		} // end of post type function
		
		public function admin_add_meta_box() {
			add_meta_box( 'pfg-upload', __('Add Portfolio Filter Gallery', 'portfolio-filter-gallery'), array(&$this, 'pfg_image_upload'), 'awl_filter_gallery', 'normal', 'default' );
			add_meta_box( 'pfg-shortcode', __('Copy Shortcode', 'portfolio-filter-gallery'), array(&$this, 'PFG_Shortcode'), 'awl_filter_gallery', 'side', 'default' );
		}
			
		public function pfg_image_upload($post) {
			//js
			wp_enqueue_script('jquery');
			//wp_enqueue_script('pfg-popper-js', PFG_PLUGIN_URL . 'js/popper.min.js', array('jquery'));
			wp_enqueue_script('pfg-bootstrap-js', PFG_PLUGIN_URL . 'js/bootstrap.js', array('jquery'));
			wp_enqueue_script('pfg-brp-multiselect-js', PFG_PLUGIN_URL . 'js/bootstrap-multiselect.min.js', array('jquery'));
			wp_enqueue_script('pfg-option-tab-js', PFG_PLUGIN_URL . 'js/pfg-option-tab.js', array('jquery'));
			wp_enqueue_script('pfg-uploader-js', PFG_PLUGIN_URL . 'js/pfg-uploader.js', array('jquery'));
			wp_enqueue_script( 'awl-pfg-color-picker-js', plugins_url('js/pfg-color-picker.js', __FILE__ ), array( 'wp-color-picker' ), false, true );
			wp_enqueue_script('media-upload');
			//CSS
			wp_enqueue_style('pfg-uploader-css', PFG_PLUGIN_URL . 'css/pfg-uploader.css');
			wp_enqueue_style('pfg-bootstrap-css', PFG_PLUGIN_URL . 'css/bootstrap.min.css');
			wp_enqueue_style('pfg-brp-multiselect-css', PFG_PLUGIN_URL . 'css/bootstrap-multiselect.css');
			wp_enqueue_style('pfg-option-tab-css', PFG_PLUGIN_URL . 'css/pfg-option-tab.css');
			wp_enqueue_media();
			wp_enqueue_style( 'wp-color-picker' );
			require_once('filter-gallery-settings.php');
		}// end of upload multiple image
		
		public function PFG_Shortcode($post) { ?>
			<div class="pw-shortcode">
				<input type="text" name="shortcode" id="shortcode" value="<?php echo "[PFG id=".$post->ID."]"; ?>" readonly style="height: 60px; text-align: center; font-size: 20px; width: 100%; border: 2px dotted;">
				<p id="pw-copt-code"><?php _e('Shortcode copied to clipboard!', 'portfolio-filter-gallery'); ?></p>
				<p><?php _e('Copy & Embed shortcode into any Page/ Post / Text Widget to display your image gallery on site.', 'portfolio-filter-gallery'); ?><br></p>
			</div>
			<span onclick="copyToClipboard('#shortcode')" class="pw-copy dashicons dashicons-clipboard"></span>
			<style>
			.pw-copy {
				position: absolute;
				top: 9px;
				right: 24px;
				font-size: 26px;
				cursor: pointer;
			}
			</style>
			<script>
			jQuery( "#pw-copt-code" ).hide();
			function copyToClipboard(element) {
			  var $temp = jQuery("<input>");
			  jQuery("body").append($temp);
			  $temp.val(jQuery(element).val()).select();
			  document.execCommand("copy");
			  $temp.remove();
			  jQuery( "#shortcode" ).select();
			  jQuery( "#pw-copt-code" ).fadeIn();
			}
			</script>
			<?php
		}// end of gallery generation
		
		public function _ig_ajax_callback_function($id) { ?>
			<script type="text/javascript">
				jQuery(function(jQuery) {
					jQuery('.pfg-filters').multiselect ({
						buttonWidth: '215px',
						enableFiltering: true,
						nonSelectedText: 'Select Category For Image!'
					});
				});
			</script><?php
			//wp_get_attachment_image_src ( int $attachment_id, string|array $size = 'thumbnail', bool $icon = false );
			//thumb, thumbnail, medium, large, post-thumbnail
			$thumbnail = wp_get_attachment_image_src($id, 'thumbnail', true);
			$attachment = get_post( $id ); // $id = attachment id
			$all_category = get_option('awl_portfolio_filter_gallery_categories');
			?>
			<li class="item image" id="<?php echo $id; ?>" data-position="<?php echo $id; ?>">
				<img class="new-image" src="<?php echo $thumbnail[0]; ?>" alt="<?php echo get_the_title($id); ?>" style="height: 150px; width: 98%; border-radius: 8px;">
				<input type="hidden" id="image-ids[]" name="image-ids[]" value="<?php echo $id; ?>" />
				
				<select id="slide-type[]" name="slide-type[]" class="form-control" style="width: 98% !important;" placeholder="Image Title" value="<?php echo $image_type; ?>" >
					<option value="image" <?php if($image_type == "image") echo "selected=selected"; ?>> <?php _e('Image', 'portfolio-filter-gallery'); ?> </option>
					<option value="video" <?php if($image_type == "video") echo "selected=selected"; ?>> <?php _e('Video', 'portfolio-filter-gallery'); ?> </option>
				</select>
				<input type="text" name="image-title[]" id="image-title[]" style="width: 98%;" placeholder="Image Title" value="<?php echo get_the_title($id); ?>">
				<input type="text" name="slide-alt[]" id="slide-alt[]" style="width: 98%;" placeholder="<?php _e('Image Alt', 'portfolio-filter-gallery'); ?>" value="<?php echo get_post_meta($id, '_wp_attachment_image_alt', TRUE); ?>">
				<textarea name="image-desc[]" id="image-desc[]" style="width: 98%;" placeholder="Type description here.."></textarea>
				<input type="text" name="image-link[]" id="image-link[]" style="width: 98%;" placeholder="Video URL / Link URL">
				<?php
				if(isset($filters[$id])) {
					$selected_filters_array = $filters[$id];
				} else {
					$selected_filters_array = array();
				} ?>
				<select class="pfg-filters form-control" name="filters[<?php echo $id; ?>][]" multiple="multiple" id="filters" style="width: 98%;">
					<?php
					foreach ($all_category as $key => $value) {
						if($key != 0) { ?>
							<strong><option value="<?php echo $key; ?>"><?php echo ucwords(stripcslashes($value)); ?></option></strong><?php
						}
					} ?>
				</select>
				<?php foreach ($selected_filters_array as $key => $value) { ?>
				<input type="hidden" name="filter-image[<?php echo $value; ?>][]" id="filter-image[]" style="width: 98%;" value="<?php echo $id; ?>" >
				<?php } ?>
				<a class="pw-trash-icon" name="remove-image" id="remove-image" href="#"><span class="dashicons dashicons-trash"></span></a>
			</li>
			<?php
		}
		
		public function _ajax_pfg_gallery() {
			echo $this->_ig_ajax_callback_function($_POST['imageId']);
			die;
		}
		
		public function _pfg_save_settings($post_id) {
			if(isset($_POST['pfg_save_nonce'])) {
				if (!isset( $_POST['pfg_save_nonce'] ) || ! wp_verify_nonce( $_POST['pfg_save_nonce'], 'pfg_save_settings' ) ) {
				   print 'Sorry, your nonce did not verify.';
				   exit;
				
				} else {
					
					$pfg_theme						= sanitize_text_field($_POST['pfg_theme']); 
					$gallery_direction				= sanitize_text_field($_POST['gallery_direction']); 
					$image_hover_effect_theme2		= sanitize_text_field($_POST['image_hover_effect_theme2']); 
					$image_hover_effect_one_2d		= sanitize_text_field($_POST['image_hover_effect_one_2d']); 
					$image_hover_effect_two			= sanitize_text_field($_POST['image_hover_effect_two']);
					$image_hover_effect_type		= sanitize_text_field($_POST['image_hover_effect_type']); 
					$image_hover_effect_one			= sanitize_text_field($_POST['image_hover_effect_one']); 
					$title_color					= sanitize_text_field($_POST['title_color']); 
					$title_bg_color					= sanitize_text_field($_POST['title_bg_color']);
					$title_size2					= sanitize_text_field($_POST['title_size2']); 
					$pfg_read_more					= sanitize_text_field($_POST['pfg_read_more']); 
					$link_on_img					= sanitize_text_field($_POST['link_on_img']); 
					$read_txt						= sanitize_text_field($_POST['read_txt']);
					$border_hide					= sanitize_text_field($_POST['border_hide']);
					$border_size					= sanitize_text_field($_POST['border_size']);
					$border_color					= sanitize_text_field($_POST['border_color']); 
					$thumb_spacing					= sanitize_text_field($_POST['thumb_spacing']); 
					$thumb_spacing2					= sanitize_text_field($_POST['thumb_spacing2']); 
					$title_thumb2					= sanitize_text_field($_POST['title_thumb2']); 
					$title_color2					= sanitize_text_field($_POST['title_color2']); 
					$title_bg_color2				= sanitize_text_field($_POST['title_bg_color2']);
					$title_bg_opacity				= sanitize_text_field($_POST['title_bg_opacity']);
					$title_size						= sanitize_text_field($_POST['title_size']); 
					$border_hide2					= sanitize_text_field($_POST['border_hide2']); 
					$border_size2					= sanitize_text_field($_POST['border_size2']); 
					$border_color2					= sanitize_text_field($_POST['border_color2']); 
					$image_numbering2				= sanitize_text_field($_POST['image_numbering2']);
					$video_auto_play				= sanitize_text_field($_POST['video_auto_play']); 
					$link_nofollow					= sanitize_text_field($_POST['link_nofollow']); 
					$link_noopener					= sanitize_text_field($_POST['link_noopener']); 
					$link_noreferrer				= sanitize_text_field($_POST['link_noreferrer']); 
					$hide_filters					= sanitize_text_field($_POST['hide_filters']); 
					$hide_all_button				= sanitize_text_field($_POST['hide_all_button']); 
					$all_txt						= sanitize_text_field($_POST['all_txt']); 
					$sort_filter_order				= sanitize_text_field($_POST['sort_filter_order']);
					$pfg_filter_style				= sanitize_text_field($_POST['pfg_filter_style']); 
					$filter_position				= sanitize_text_field($_POST['filter_position']); 
					$multi_filters					= sanitize_text_field($_POST['multi_filters']);
					$multi_filters_logic			= sanitize_text_field($_POST['multi_filters_logic']);
					$ascending						= sanitize_text_field($_POST['ascending']); 
					$asc_txt						= sanitize_text_field($_POST['asc_txt']); 
					$descending						= sanitize_text_field($_POST['descending']);
					$desc_txt						= sanitize_text_field($_POST['desc_txt']); 
					$shuffle						= sanitize_text_field($_POST['shuffle']); 
					$shuffle_txt					= sanitize_text_field($_POST['shuffle_txt']); 
					$search_box						= sanitize_text_field($_POST['search_box']); 
					$search_txt						= sanitize_text_field($_POST['search_txt']);
					$filter_bg_color				= sanitize_text_field($_POST['filter_bg_color']); 
					$light_boxt1					= sanitize_text_field($_POST['light_boxt1']); 
					$pf_gallery_load_more			= sanitize_text_field($_POST['pf_gallery_load_more']); 
					$pf_limit						= sanitize_text_field($_POST['pf_limit']); 
					$load_text						= sanitize_text_field($_POST['load_text']); 
					$load_button_color				= sanitize_text_field($_POST['load_button_color']); 
					$load_text_color				= sanitize_text_field($_POST['load_text_color']);
					$no_more_text					= sanitize_text_field($_POST['no_more_text']);
					$gal_size 						= sanitize_text_field($_POST['gal_size']);
					$col_large_desktops				= sanitize_text_field($_POST['col_large_desktops']);
					$col_desktops 					= sanitize_text_field($_POST['col_desktops']);
					$col_tablets 					= sanitize_text_field($_POST['col_tablets']);
					$col_phones 					= sanitize_text_field($_POST['col_phones']);
					$image_hover_effect_four		= sanitize_text_field($_POST['image_hover_effect_four']);
					$title_thumb					= sanitize_text_field($_POST['title_thumb']);
					$image_numbering				= sanitize_text_field($_POST['image_numbering']);
					$no_spacing						= sanitize_text_field($_POST['no_spacing']);
					$gray_scale						= sanitize_text_field($_POST['gray_scale']);
					$url_target						= sanitize_text_field($_POST['url_target']);
					$filter_title_color				= sanitize_text_field($_POST['filter_title_color']);
					$light_box						= sanitize_text_field($_POST['light-box']);
					$bootstrap_disable				= sanitize_text_field($_POST['bootstrap_disable']);
					$custom_css						= $_POST['custom-css'];
					
					$i = 0;
					
					$image_ids_val = isset( $_POST['image-ids'] ) ? (array) $_POST['image-ids'] : array();
					$image_ids_val = array_map( 'sanitize_text_field', $image_ids_val );
					
					$filters = isset( $_POST['filters'] ) ? (array) $_POST['filters'] : array();
					$filter_image = isset( $_POST['filter-image'] ) ? (array) $_POST['filter-image'] : array();

					foreach($image_ids_val as $image_id) {
						
						$image_ids[]				= sanitize_text_field($_POST['image-ids'][$i]);
						$image_titles[]				= sanitize_text_field($_POST['image-title'][$i]);
						$image_alt[$image_id]		= sanitize_text_field($_POST['slide-alt'][$i]);
						$image_type[$image_id]		= sanitize_text_field($_POST['slide-type'][$i]);
						$image_desc[]				= $_POST['image-desc'][$i];
						$image_link[$image_id]		= sanitize_text_field($_POST['image-link'][$i]);
						
						if(isset($filters[$image_id])) {
							$filters_new[$image_id] = array_map( 'sanitize_text_field', $filters[$image_id]);
						}

						//$filter_image_new[] = array_map( 'sanitize_text_field', $filter_image);
						
						$single_image_update = array(
							'ID'           => $image_id,
							'post_title'   => $image_titles[$i],
							'post_content'   => $image_desc[$i],
						);
						
						wp_update_post( $single_image_update );
						$i++;
					}
					
					$portfolio_post_setting = array (
						'image-ids'  					=> $image_ids,
						'image_title'  					=> $image_titles,
						'slide-type'  					=> $image_type,
						'image-desc'  					=> $image_desc,
						'slide-alt'  					=> $image_alt,
						'image-link'  					=> $image_link,
						'filters'  						=> $filters_new,
						'filter-image'  				=> $filter_image,
						'pfg_theme'						=> $pfg_theme, 
						'gallery_direction'				=> $gallery_direction, 
						'image_hover_effect_theme2'		=> $image_hover_effect_theme2, 
						'image_hover_effect_one_2d'		=> $image_hover_effect_one_2d, 
						'image_hover_effect_two'		=> $image_hover_effect_two,
						'image_hover_effect_type'		=> $image_hover_effect_type, 
						'image_hover_effect_one'		=> $image_hover_effect_one, 
						'title_color'					=> $title_color, 
						'title_bg_color'				=> $title_bg_color,
						'title_size2'					=> $title_size2, 
						'pfg_read_more'					=> $pfg_read_more, 
						'link_on_img'					=> $link_on_img, 
						'read_txt'						=> $read_txt,
						'border_hide'					=> $border_hide,
						'border_size'					=> $border_size,
						'border_color'					=> $border_color, 
						'thumb_spacing'					=> $thumb_spacing, 
						'thumb_spacing2'				=> $thumb_spacing2, 
						'title_thumb2'					=> $title_thumb2, 
						'title_color2'					=> $title_color2, 
						'title_bg_color2'				=> $title_bg_color2,
						'title_bg_opacity'				=> $title_bg_opacity,
						'title_size'					=> $title_size, 
						'border_hide2'					=> $border_hide2, 
						'border_size2'					=> $border_size2, 
						'border_color2'					=> $border_color2, 
						'image_numbering2'				=> $image_numbering2,
						'video_auto_play'				=> $video_auto_play, 
						'link_nofollow'					=> $link_nofollow, 
						'link_noopener'					=> $link_noopener, 
						'link_noreferrer'				=> $link_noreferrer, 
						'hide_filters'					=> $hide_filters, 
						'hide_all_button'				=> $hide_all_button, 
						'all_txt'						=> $all_txt, 
						'sort_filter_order'				=> $sort_filter_order,
						'pfg_filter_style'				=> $pfg_filter_style, 
						'filter_position'				=> $filter_position, 
						'multi_filters'					=> $multi_filters,
						'multi_filters_logic'			=> $multi_filters_logic, 
						'ascending'						=> $ascending, 
						'asc_txt'						=> $asc_txt, 
						'descending'					=> $descending,
						'desc_txt'						=> $desc_txt, 
						'shuffle'						=> $shuffle, 
						'shuffle_txt'					=> $shuffle_txt, 
						'search_box'					=> $search_box, 
						'search_txt'					=> $search_txt,
						'filter_bg_color'				=> $filter_bg_color, 
						'light_boxt1'					=> $light_boxt1, 
						'pf_gallery_load_more'			=> $pf_gallery_load_more, 
						'pf_limit'						=> $pf_limit, 
						'load_text'						=> $load_text, 
						'load_button_color'				=> $load_button_color, 
						'load_text_color'				=> $load_text_color,
						'no_more_text'					=> $no_more_text,
						'gal_size'						=> $gal_size,
						'col_large_desktops'			=> $col_large_desktops,
						'col_desktops' 			   		=> $col_desktops,
						'col_tablets'					=> $col_tablets,
						'col_phones' 					=> $col_phones,
						'image_hover_effect_four'		=> $image_hover_effect_four,
						'title_thumb'					=> $title_thumb,
						'image_numbering'				=> $image_numbering,
						'no_spacing'					=> $no_spacing,
						'gray_scale'					=> $gray_scale,
						'url_target'					=> $url_target,
						'filter_title_color'			=> $filter_title_color,
						'light-box'						=> $light_box,
						'bootstrap_disable'				=> $bootstrap_disable,
						'custom-css'					=> $custom_css,
						
					);		
					$awl_portfolio_shortcode_setting = "awl_filter_gallery".$post_id;
					update_post_meta($post_id, $awl_portfolio_shortcode_setting, $portfolio_post_setting);
					
				}
				
			}
		}// end save setting
		
		//filter/category page
		public function awl_filter_page() {
			require_once('filters.php');
		}
		//filter/category page
		public function update_old_settings_page() {
			require_once('update-old-settings.php');
		}
		//Doc page
		public function pfg_doc_page() {
			require_once('docs.php'); 
		}
	}
	$pfg_portfolio_gallery_object = new Awl_Portfolio_Filter_Gallery();
	require_once('filter-gallery-shortcode.php');
} ?>