<?php
//filters page

//js
wp_enqueue_script('jquery');
wp_enqueue_script('jquery-effects-shake');
//css
wp_enqueue_style('awl-pfg-bootstrap-css', PFG_PLUGIN_URL . 'css/bootstrap.min.css');
wp_enqueue_style('awl-pfg-filter-css', PFG_PLUGIN_URL . 'css/filter-template.css');
wp_enqueue_style('awl-pfg-font-css', PFG_PLUGIN_URL . 'css/font-awesome.css');

$all_category = get_option('awl_portfolio_filter_gallery_categories');
if(is_array($all_category)){
	if(!isset($all_category[0])) {
		$all_category[0] = "All";
		update_option("awl_portfolio_filter_gallery_categories", $all_category);
	}
} else {
	$all_category[0] = "All";
	update_option("awl_portfolio_filter_gallery_categories", $all_category);
}
?>
<!--Category Section Start-->
<div class="row awl-spacing-md" id="update_div">
	<div class="container">
		<div class="form-style-5 text-center">
			<input type="button" class="button button-primary button-hero load-customize hide-if-no-customize" id="add_new_category_button" name="add_new_category_button" value="Add New Category" onclick="return DoAction('showaddform', '');" />
			<fieldset>
				<div id="add-form-div" class="row" style="display:none;">
					<form id="add-form" name="add-form">
						<h3><?php _e('Add New Category', 'portfolio-filter-gallery'); ?></h3><hr>
						<div class="col-md-6">
							<input type="text" id="category_name" name="category_name" placeholder="Type Category Name">
						</div>
						<div class="col-md-6">
							<div class="col-md-6">
								<input type="button" class="button button-primary button-hero load-customize hide-if-no-customize lower-btn" id="add_new_category_button" name="add_new_category_button" value="Add Category" onclick="return DoAction('add', '');" />
							</div>
							<div class="col-md-6">
								<input type="button" class="button button-primary button-hero load-customize hide-if-no-customize lower-btn" id="close_category" name="close_category" value="Close" onclick="return DoAction('close', '');" />
							</div>
						</div>
					</form>
				</div>
				<div id="update-form-div" style="display: none;"></div>
			</fieldset>
		</div>
		
		<?php
		$action= "";
		if(isset($_POST['action'])){
			$action = $_POST['action'];
		}
		?>
		<div  id="cat-table-div" class="<?php if($action != "add" && $action != "update") echo 'form-style-5'; ?>">
			<table class="table table-hover" id="cat-table">
				<thead>
					<tr>
						<th>#</th>
						<th><?php _e('Category Name', 'portfolio-filter-gallery'); ?></th>
						<th><?php _e('Action', 'portfolio-filter-gallery'); ?></th>
						<th class="text-center"><input type="checkbox" name="check-all" id="check-all"></th>
					</tr>
				</thead>
				<tbody id="update_div" name="update_div">
					<?php
					$all_category = get_option('awl_portfolio_filter_gallery_categories');
					$n = 0;
					if($all_category) {
						foreach ($all_category as $key => $value) { 
						if($n != 0) {
						?>
						<tr id="record-<?php echo $key; ?>">
							<td><?php echo $n; ?>.</td>
							<td id="cat_name" name="cat_name"><?php echo stripcslashes($value); ?></td>
							<td>&nbsp;
								<i class="fa fa-pencil-square cat_icon" id="update_category" name="update_category"  onclick="return DoAction('edit', '<?php echo $key;?>');"></i>&nbsp;&nbsp;&nbsp;
								<?php if($key != 0 ) { ?><i class="fa fa-trash cat_icon" id="delete_category" name="delete_category" onclick="return DoAction('delete', '<?php echo $key;?>');"></i><?php } ?>
							</td>
							<td class="text-center">
								<?php if($key != 0 ) { ?><input type="checkbox" id="cat_all_check" value="<?php echo $key;?>"><?php } ?>
							</td>
						</tr>
						<?php 
						}
						$n++;
						} // end foreach
					} ?>
					<tr>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<td>&nbsp;</td>
						<?php if($all_category){ ?>
						<td class="text-center"><i class="fa fa-trash cat_icon" id="delete_all_category" name="delete_all_category" onclick="return DoAction('delete_all_category', '-1');"></i></td>
						<?php } ?>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>
<script>
jQuery(document).ready(function() {
	jQuery("input:checkbox").prop('checked', false);
	jQuery("#check-all").change(function () {
		jQuery("input:checkbox").prop('checked', jQuery(this).prop("checked"));
	});
});

// category add / edit / update / close
function DoAction(action, id) {
	
	//show add form
	if(action == "showaddform") {
		jQuery("#add-form-div").show();
		jQuery("#add_new_category_button").hide();
	}
	
	//hide form
	if(action == "close") {
		jQuery("#add-form-div").hide(); // hide add form
		jQuery("#update-form").hide(); // hide update form
		jQuery("#add_new_category_button").show();
	}
	
	//add category
	if(action == "add") {
		// validate blank value
		var category_name = jQuery("#category_name").val();
		if(category_name == "") {
			jQuery("#category_name").focus();
			return false;
		}
		
		jQuery.ajax({
			type: 'POST',
			url: location.href,
			data: jQuery('#add-form').serialize() + '&action=' + action,
			success:function(response){
				jQuery('#cat-table-div').html(jQuery(response).find('div#cat-table-div'));
				jQuery('#hide_btn').html(jQuery(response).find('div.hide_btn'));
				jQuery("#hide_this").remove();
				jQuery("#cat-table").remove();
				jQuery("#add-form-div").hide();
				jQuery("#add_new_category_button").show();
				jQuery("#add-form").trigger('reset');
				jQuery("#check-all").change(function () {
					jQuery("input:checkbox").prop('checked', jQuery(this).prop("checked"));
				});
			}
		});
	}
	
	//edit and show update form
	if(action == "edit") {
		jQuery("#add_new_category_button").hide();
		jQuery("#add-form-div").hide();
		jQuery.ajax({
			type: 'POST',
			url: location.href,
			data: '&action=' + action + "&id=" + id,
			success:function(response){
				jQuery("#update-form-div").show();
				jQuery('#update-form-div').html(jQuery(response).find('div#update-form'));
			}
		});
	}

	//update the category
	if(action == "update") {
		// validate blank value
		var category_name = jQuery("#edit_category_name").val();
		if(category_name == "") {
			jQuery("#edit_category_name").focus();
			jQuery( "#edit_category_name" ).effect( "shake" );
			return false;
		}
		
		jQuery.ajax({
			type: 'POST',
			url: location.href,
			data: '&action=' + action + "&id=" + id + "&category_name=" + category_name,
			success:function(response){
				jQuery("#update-form").remove();
				jQuery("#update-form-div").hide();
				// new updated response
				jQuery('#cat-table-div').html(jQuery(response).find('div#cat-table-div'));
				jQuery("#cat-table").remove();
				jQuery("#add_new_category_button").show();
			}
		});
	}
	
	//delete category
	if(action == "delete") {
		
		jQuery.ajax({
			type: 'POST',
			url: location.href,
			data: '&action=' + action + "&id=" + id,
			success:function(response){
				jQuery( "#record-" + id ).fadeOut( 1500, "linear" );
			}
		});
	}
	
	//delete all category
	if(action == "delete_all_category") {
		if(confirm('Are you sure want to delete all selected articles?')) {
			var AllCategories = [];
			
			//collect all selected article ids
			jQuery('input:checkbox:checked').map(function() {
				if(jQuery.isNumeric(this.value)) {
					AllCategories.push(this.value);
				}
			});
			//console.log(AllCategories);
			
			// check if any article selected or not
			if(AllCategories.length) {
				jQuery.ajax({
					type: 'POST',
					url: location.href,
					data: '&action=' + action + "&id=" + AllCategories,
					success:function(response){
						for (i = 0; i < AllCategories.length; i++) {
							jQuery( "#record-" + AllCategories[i] ).fadeOut( 1500, "linear" );
						}
						if(AllCategories){
							jQuery( "#hide_me" ).fadeIn( 7000, "linear" );
						}
					}
				});
			}else {
				alert("No category selected to delete.");
			}
		}
	}
}
</script>
<?php
if(isset($_POST['action'])){
	//print_r($_POST);
	$action = $_POST['action'];
	
	if($action == "add"){
		$category_name = sanitize_text_field($_POST['category_name']);
		$new_category = array($category_name);

		$all_category = get_option('awl_portfolio_filter_gallery_categories');
		if(is_array($all_category)) {
			$all_category = array_merge($all_category, $new_category);
		} else {
			$all_category = $new_category;
		}
		if(update_option( 'awl_portfolio_filter_gallery_categories', $all_category)){
		//print_r( $insert_query);
		?>
			<div class="<?php if($action != "add" && $action != "update") echo'form-style-5'; ?>" id="cat-table-div">
				<table class="table table-hover" id="cat-table">
					<thead>
						<tr>
							<th>#</th>
							<th><?php _e('Category Name', 'portfolio-filter-gallery'); ?></th>
							<th><?php _e('Action', 'portfolio-filter-gallery'); ?></th>
							<th class="text-center"><input type="checkbox" name="check-all" id="check-all"></th>
						</tr>
					</thead>
					<tbody id="update_div" name="update_div">
						<?php
						$all_category = get_option('awl_portfolio_filter_gallery_categories');
						$n = 0;
						if($all_category) {
							foreach ($all_category as $key => $value) { 
							if($n != 0) { ?>
							<tr id="record-<?php echo $key;?>">
								<td><?php echo $n; ?>.</td>
								<td id="category_name" name="category_name"><?php echo stripcslashes($value); ?></td>
								<td>&nbsp;
									<i class="fa fa-pencil-square cat_icon" id="update_category" name="update_category"  onclick="return DoAction('edit', '<?php echo $key;?>');"></i>&nbsp;&nbsp;&nbsp;
									<?php if($key != 0 ) { ?><i class="fa fa-trash cat_icon" id="delete_category" name="delete_category" onclick="return DoAction('delete', '<?php echo $key;?>');"></i><?php } ?>
								</td>
								<td class="text-center">
									<?php if($key != 0 ) { ?><input type="checkbox" id="cat_all_check" value="<?php echo $key;?>"><?php } ?>
								</td>
							</tr>
							<?php 
							}
							$n++;
							} // end foreach
						} ?>
						<tr>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<?php if($all_category){
							?>
							<td class="text-center"><i class="fa fa-trash cat_icon" id="delete_all_category" name="delete_all_category" onclick="return DoAction('delete_all_category', '-1');"></i></td>
							<?php } ?>
						</tr>
					</tbody>
				</table>
			</div>
			<?php
		} else {
			echo "<div id='result-msg'>Error! unable to category.</div>";
		}
	}
	
	if($action == "edit"){
		$id = $_POST['id'];
		$all_category = get_option('awl_portfolio_filter_gallery_categories');
		$edit_category_name =  $all_category[$id]; ?>
		<div id="update-form">
			<form id="add-form" name="add-form">
				<h3><?php _e('Edit Category', 'portfolio-filter-gallery'); ?></h3><hr>
				<div class="col-md-6">
					<input type="text" id="edit_category_name" name="edit_category_name" value="<?php echo $edit_category_name; ?>" >
				</div>
				<div class="col-md-6">
					<div class="col-md-6">
						<input type="button" class="button button-primary button-hero load-customize hide-if-no-customize lower-btn" id="add_new_category_button" name="add_new_category_button" value="Update Category" onclick="return DoAction('update', '<?php echo $id; ?>');" />
					</div>
					<div class="col-md-6">
						<input type="button" class="button button-primary button-hero load-customize hide-if-no-customize lower-btn" id="close_category" name="close_category" value="Close" onclick="return DoAction('close', '');" />
					</div>
				</div>
			</form>
		</div>
		<?php
	}
	
	if($action == "update"){
		$id = $_POST['id'];
		$category_name = $_POST['category_name'];
		$all_category = get_option('awl_portfolio_filter_gallery_categories');
		
		$replacements = array($id => $category_name);
		$all_category = array_replace($all_category, $replacements);
		update_option( 'awl_portfolio_filter_gallery_categories', $all_category); ?>
		<div class="<?php if($action != "add" && $action != "update") echo'form-style-5'; ?>" id="cat-table-div">
				<table class="table table-hover" id="cat-table">
					<thead>
						<tr>
							<th>#</th>
							<th><?php _e('Category Name', 'portfolio-filter-gallery'); ?></th>
							<th><?php _e('Action', 'portfolio-filter-gallery'); ?></th>
							<th class="text-center"><input type="checkbox" name="check-all" id="check-all"></th>
						</tr>
					</thead>
					<tbody id="update_div" name="update_div">
						<?php
						$all_category = get_option('awl_portfolio_filter_gallery_categories');
						$n = 0;
						if($all_category) {
							foreach ($all_category as $key => $value) { 
							if($n != 0) { ?>
							<tr id="record-<?php echo $key;?>">
								<td><?php echo $n; ?>.</td>
								<td id="cat_name" name="cat_name"><?php echo $value; ?></td>
								<td>&nbsp;
									<i class="fa fa-pencil-square cat_icon" id="update_category" name="update_category"  onclick="return DoAction('edit', '<?php echo $key;?>');"></i>&nbsp;&nbsp;&nbsp;
									<?php if($key != 0 ) { ?><i class="fa fa-trash cat_icon" id="delete_category" name="delete_category" onclick="return DoAction('delete', '<?php echo $key;?>');"></i><?php } ?>
								</td>
								<td class="text-center">
									<?php if($key != 0 ) { ?><input type="checkbox" id="cat_all_check" value="<?php echo $key;?>"><?php } ?>
								</td>
							</tr>
							<?php
							}
							$n++;
							} // end foreach
						} ?>
						<tr>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
							<?php if($all_category) { ?>
							<td class="text-center"><i class="fa fa-trash cat_icon" id="delete_all_category" name="delete_all_category" onclick="return DoAction('delete_all_category', '-1');"></i></td>
							<?php } ?>
						</tr>
					</tbody>
				</table>
			</div>
		<?php
	}
	
	if($action == "delete") {
		$id = $_POST['id'];
		$all_category = get_option('awl_portfolio_filter_gallery_categories');
		//print_r($all_category);
		if(is_array($all_category)) {
			unset($all_category[$id]);
			$all_category = array_filter( $all_category );
		}
		if(update_option( 'awl_portfolio_filter_gallery_categories', $all_category)){
			echo "Category has been deleted.";
		}
	}
	
	if($action == "delete_all_category") {
		$ids = explode("," ,$_POST['id']);
		$count = count($ids);
		$n = 0;
		$all_category = get_option('awl_portfolio_filter_gallery_categories');
		//print_r($all_category);
		if(is_array($all_category)) {
			foreach($ids as $id) {
				unset($all_category[$id]);
				$all_category = array_filter( $all_category );
			}
		}
		update_option( 'awl_portfolio_filter_gallery_categories', $all_category);
	}
}
?>