<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
//CSS
wp_enqueue_script('jquery');
wp_enqueue_style('pfg-metabox-css', PFG_PLUGIN_URL . 'css/metabox.css');

//load settings
$pf_gallery_settings = get_post_meta( $post->ID, 'awl_filter_gallery'.$post->ID, true);
$image_gallery_id = $post->ID;
/*  echo "<pre>";
print_r($pf_gallery_settings);
echo "</pre>";  */ 
?>
<div class="row gallery-content-photo-wall">
	<?php
	// hide notice ((1 = show, 2 = hide))
	$pfg_hide_notice = get_option('pfg_hide_notice', 1);
	
	// hide the update setting notice once users updated (1 = process not done, 2 = process done)
	$old_setting_update_status = get_option('pfg_old_settings_updated', 1);
	if($old_setting_update_status == 1 && $pfg_hide_notice == 1){
	?>
	<div style="text-align:center; border: solid 2px red; padding: 50px;">
		<h1 style="color:red;"><strong>!!! IMPORTANT NOTICE !!!</strong></h1>
		<h1 style="color:blue;">Update Plugin Settings Those Users Was Using Version 5.1.5 Or Previous Once</h1>
		<p>It will prevent you to loose your previouly created galleries and settings.</p>
		<a href="edit.php?post_type=awl_filter_gallery&page=pfg-update-plugin" name="update_settings" id="update_settings" class="button button-primary button-hero">Click Here</a>
	</div>
	<?php } ?>
	
	<!--Add New Image Button-->
	<div class="file-upload">
		<div class="image-upload-wrap">
			<input class="add-new-images file-upload-input" id="upload_image_button" name="upload_image_button" value="Upload Image" />
			<div class="drag-text">
				<h3><?php _e('ADD IMAGES', 'portfolio-filter-gallery'); ?></h3>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-lg-12 bhoechie-tab-container">
		<div class="col-lg-2 col-md-2 col-sm-2 col-xs-2 bhoechie-tab-menu">
			<div class="list-group">
				<a href="#" class="list-group-item active text-center">
					<span class="dashicons dashicons-format-image"></span><br/><?php _e('Photos', 'portfolio-filter-gallery'); ?>
				</a>
				<a href="#" class="list-group-item text-center">
					<span class="dashicons dashicons-layout"></span><br/><?php _e('Layouts', 'portfolio-filter-gallery'); ?>
				</a>
				<a href="#" class="list-group-item text-center">
					<span class="dashicons dashicons-admin-generic"></span><br/><?php _e('Config', 'portfolio-filter-gallery'); ?>
				</a>
				<a href="#" class="list-group-item text-center">
					<span class="dashicons dashicons-editor-insertmore"></span><br/><?php _e('Filters', 'portfolio-filter-gallery'); ?>
				</a>
				<a href="#" class="list-group-item text-center">
					<span class="dashicons dashicons-welcome-view-site"></span><br/><?php _e('LightBox', 'portfolio-filter-gallery'); ?>
				</a>
				<a href="#" class="list-group-item text-center">
					<span class="dashicons dashicons-screenoptions"></span><br/><?php _e('Load More', 'portfolio-filter-gallery'); ?>
				</a>
				<a href="#" class="list-group-item text-center">
					<span class="dashicons dashicons-media-code"></span><br/><?php _e('Custom CSS', 'portfolio-filter-gallery'); ?>
				</a>
			</div>
		</div>
		<div class="col-lg-10 col-md-10 col-sm-10 col-xs-10 bhoechie-tab">
			<!-- flight section -->
			<div class="bhoechie-tab-content active">
			<h1><?php _e('Photos', 'portfolio-filter-gallery'); ?></h1>
				
				<button type="button" id="remove-all-images" name="remove-all-images" class="btn btn-danger remove-all-images"><?php _e('Delete All Images', 'portfolio-filter-gallery'); ?></button>
				<!-- Single button -->
				<div class="btn-group" id="sort-all-slides">
				  <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
					<?php _e('Sorting', 'portfolio-filter-gallery'); ?> <span class="caret"></span>
				  </button>
				  <ul class="dropdown-menu" >
					<li onclick="return SortSlides('ASC');"> <?php _e('Ascending', 'portfolio-filter-gallery'); ?></li>
					<li role="separator" class="divider"></li>
					<li onclick="return SortSlides('DESC');"> <?php _e('Descending', 'portfolio-filter-gallery'); ?></li>
					<li role="separator" class="divider"></li>
					<li onclick="return SortSlides('alphabetically');"> <?php _e('By Title', 'portfolio-filter-gallery'); ?></li>
				  </ul>
				</div>
				
				<hr>
				<!--Photos from wordpress-->
			<div id="image-gallery">
				<p><strong><?php _e('First add filters for images by click on', 'portfolio-filter-gallery'); ?> <a href="edit.php?post_type=awl_filter_gallery&page=pfg-filter-page"><?php _e('FILTERS', 'portfolio-filter-gallery'); ?></a> <?php _e('menu link.', 'portfolio-filter-gallery'); ?></strong></p>
				<p><strong><?php _e('Please do not repeat images.', 'portfolio-filter-gallery'); ?></strong></p>
				
				<br>
				<ul id="remove-images" class="sbox listitems">
					<?php
					$allimagesetting = get_post_meta( $post->ID, 'awl_filter_gallery'.$post->ID, true);
					$all_category = get_option('awl_portfolio_filter_gallery_categories');
					
						if(isset($allimagesetting['image-ids'])) {
							if (array_key_exists("filters",$allimagesetting)) {
								$filters = $allimagesetting['filters'];
							}
							$count = 0;
							foreach($allimagesetting['image-ids'] as $id) {
							$thumbnail = wp_get_attachment_image_src($id, 'thumbnail', true);
							$attachment = get_post( $id );
							$image_alt ="";
							if(isset($allimagesetting['slide-alt'])) {
								if(isset($allimagesetting['slide-alt'][$id])) {
									$image_alt =  $allimagesetting['slide-alt'][$id];
								} else { $image_alt = $allimagesetting['slide-alt'][$count]; }
							}
							if(isset($allimagesetting['image-link'][$id])) {
								$image_link =  $allimagesetting['image-link'][$id];
							} else { $image_link = $allimagesetting['image-link'][$count]; } 
							
							if(isset($allimagesetting['image-desc'])) {
							$image_desc = $allimagesetting['image-desc'][$count];
							} else {
								$image_desc = "";
							}
							$image_type =  $allimagesetting['slide-type'][$id];
							?>
							<li class="item image" id="<?php echo $id; ?>" data-position="<?php echo $id; ?>" data-title="<?php echo get_the_title($id); ?>">
								<img class="new-image" src="<?php echo $thumbnail[0]; ?>" alt="<?php echo get_the_title($id); ?>" style="height: 150px; width: 98%; border-radius: 8px;">
								<input type="hidden" id="image-ids[]" name="image-ids[]" value="<?php echo $id; ?>" />
								
								<select id="slide-type[]" name="slide-type[]" class="form-control" style="width: 98% !important;" placeholder="Image Title" value="<?php echo $image_type; ?>" >
									<option value="image" <?php if($image_type == "image") echo "selected=selected"; ?>> <?php _e('Image', 'portfolio-filter-gallery'); ?> </option>
									<option value="video" <?php if($image_type == "video") echo "selected=selected"; ?>> <?php _e('Video', 'portfolio-filter-gallery'); ?> </option>
								</select>
								
								<input type="text" name="image-title[]" id="image-title[]" style="width: 98%;" placeholder="Image Title" value="<?php echo get_the_title($id); ?>">
								<input type="text" name="slide-alt[]" id="slide-alt[]" style="width: 98%;" placeholder="<?php _e('Image Alt','portfolio-filter-gallery'); ?>" value="<?php echo $image_alt; ?>">
								<textarea name="image-desc[]" id="image-desc[]" style="width: 98%;" placeholder="Type description here.."><?php echo stripcslashes($image_desc); ?></textarea>
								<input type="text" name="image-link[]" id="image-link[]" style="width: 98%;" placeholder="Video URL / Link URL" value="<?php echo $image_link; ?>">
								<?php
								if(isset($filters[$id])) {
									$selected_filters_array = $filters[$id];
								} else {
									$selected_filters_array = array();
								}
								?>
								<select class="pfg-filters form-control" name="filters[<?php echo $id; ?>][]" multiple="multiple" id="filters">
									<?php
									foreach ($all_category as $key => $value) {
										if($key != 0) {
										?><strong><option value="<?php echo $key; ?>" <?php if(count($selected_filters_array)) { if(in_array($key, $selected_filters_array)) echo "selected=selected"; } ?>><?php echo ucwords(stripcslashes($value)); ?></option></strong><?php
										}
									}
									?>
								</select>
								<?php foreach ($selected_filters_array as $key => $value) { 
								//print_r($selected_filters_array);
								?>
								<input type="hidden" name="filter-image[<?php echo $value; ?>][]" id="filter-image[]" style="width: 98%;" value="<?php echo $id; ?>" >
								<?php } ?>
								<a class="pw-trash-icon" name="remove-image" id="remove-image" href="#"><span class="dashicons dashicons-trash"></span></a>
							</li>
							
						<?php $count++; } // end of foreach
						} //end of if
					?>
				</ul>
			</div>
			<script type="text/javascript">
				//jQuery(document).ready(function() {
					jQuery(function(jQuery) {
						jQuery('.pfg-filters').multiselect ({
							buttonWidth: '215px',
							enableFiltering: true,
							nonSelectedText: 'Select Category For Image!'
						});
					});
					function SortSlides(order){
						if(order == "ASC") {
							jQuery(".listitems li.item").sort(sort_li).appendTo('.listitems');
							function sort_li(a, b) {
								return (jQuery(b).data('position')) > (jQuery(a).data('position')) ? 1 : -1;
							}
						}
						if(order == "alphabetically") {
							jQuery(".listitems li.item").sort(sort_li).appendTo('.listitems');
							function sort_li(a, b) {
								return (jQuery(b).data('title')) < (jQuery(a).data('title')) ? 1 : -1;
							}
						}
						if(order == "DESC") {
							jQuery(".listitems li.item").sort(sort_li).appendTo('.listitems');
							function sort_li(a, b) {
								return (jQuery(b).data('position')) < (jQuery(a).data('position')) ? 1 : -1;
							}
						}
					}
				//});
			</script>
				
			</div>
			<!-- Gallery section -->
			<div class="bhoechie-tab-content">
				<h1><?php _e('Choose Gallery Layout Type', 'portfolio-filter-gallery'); ?></h1>
				<hr>
				<?php if(isset($pf_gallery_settings['pfg_theme'])) $pfg_theme = $pf_gallery_settings['pfg_theme']; else $pfg_theme = "pfg_theme1"; ?>
				<div class="col-md-6 text-center">
					<input type="radio" name="pfg_theme" id="pfg_theme1" value="pfg_theme1" <?php if($pfg_theme == "pfg_theme1") echo "checked=checked"; ?> >
					<label for="pfg_theme1"><img class="gallery_layout_grid" style="width:60%; box-shadow:0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);" src="<?php echo PFG_PLUGIN_URL ?>/img/portfolio theme 1.png"/>
					</label>
				</div>
				<div class="col-md-6">
					<input type="radio" name="pfg_theme" id="pfg_theme2" value="pfg_theme2" <?php if($pfg_theme == "pfg_theme2") echo "checked=checked"; ?>>
					<label for="pfg_theme2"><img class="gallery_layout_masonry" style="width:60%; box-shadow:0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);" src="<?php echo PFG_PLUGIN_URL ?>/img/portfolio theme 2.png"/></label>
				</div>
			</div>

			<!-- Configuration -->
			<div class="bhoechie-tab-content">
				<h1><?php _e('Configuration', 'portfolio-filter-gallery'); ?></h1>
				<hr>
				<!--Grid-->
				<div class="pw_grid_layout_config">
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Gallery Thumbnail Resolution Size', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Choose resolution size for gallery thumbnails', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<?php if(isset($pf_gallery_settings['gal_size'])) $gal_size = $pf_gallery_settings['gal_size']; else $gal_size = "large"; ?>
								<select id="gal_size" name="gal_size" class="selectbox_settings form-control">
									<option value="thumbnail" <?php if($gal_size == "thumbnail") echo "selected=selected"; ?>><?php _e('Thumbnail - 150 x 150', 'portfolio-filter-gallery'); ?></option>
									<option value="medium" <?php if($gal_size == "medium") echo "selected=selected"; ?>><?php _e('Medium - 300 x 169', 'portfolio-filter-gallery'); ?></option>
									<option value="large" <?php if($gal_size == "large") echo "selected=selected"; ?>><?php _e('Large - 840 x 473', 'portfolio-filter-gallery'); ?></option>
									<option value="full" <?php if($gal_size == "full") echo "selected=selected"; ?>><?php _e('Full Size - 1280 x 720', 'portfolio-filter-gallery'); ?></option>
									<option value="thumbnail_300_x_300" <?php if($gal_size == "thumbnail_300_x_300") echo "selected=selected"; ?>><?php _e('Custom Thumbnail - 300 x 300', 'portfolio-filter-gallery'); ?></option>
									<option value="thumbnail_500_x_500" <?php if($gal_size == "thumbnail_500_x_500") echo "selected=selected"; ?>><?php _e('Custom Thumbnail - 500 x 500', 'portfolio-filter-gallery'); ?></option>
								</select>
							</div>
						</div>
					</div>
					<div id="" class="meta_box_holder_inside">
						<h2><?php _e('Columns Settings', 'portfolio-filter-gallery'); ?></h2>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Columns On Desktops', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Set columns for desktop', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<div class="switch-field em_size_field">
										<?php if(isset($pf_gallery_settings['col_large_desktops'])) $col_large_desktops = $pf_gallery_settings['col_large_desktops']; else $col_large_desktops = "col-lg-3"; ?>
										<select id="col_large_desktops" name="col_large_desktops" class="selectbox_settings form-control">
											<option value="col-lg-12" <?php if($col_large_desktops == "col-lg-12") echo "selected=selected"; ?>><?php _e('1 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-lg-6" <?php if($col_large_desktops == "col-lg-6") echo "selected=selected"; ?>><?php _e('2 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-lg-4" <?php if($col_large_desktops == "col-lg-4") echo "selected=selected"; ?>><?php _e('3 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-lg-3" <?php if($col_large_desktops == "col-lg-3") echo "selected=selected"; ?>><?php _e('4 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-lg-2" <?php if($col_large_desktops == "col-lg-2") echo "selected=selected"; ?>><?php _e('6 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-lg-1" <?php if($col_large_desktops == "col-lg-1") echo "selected=selected"; ?>><?php _e('12 Column', 'portfolio-filter-gallery'); ?></option>
										</select>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Columns On Tablet', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Set columns for tablet', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<div class="switch-field em_size_field">
										<?php if(isset($pf_gallery_settings['col_desktops'])) $col_desktops = $pf_gallery_settings['col_desktops']; else $col_desktops = "col-md-3"; ?>
										<select id="col_desktops" name="col_desktops" class="selectbox_settings form-control">
											<option value="col-md-12" <?php if($col_desktops == "col-md-12") echo "selected=selected"; ?>><?php _e('1 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-md-6" <?php if($col_desktops == "col-md-6") echo "selected=selected"; ?>><?php _e('2 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-md-4" <?php if($col_desktops == "col-md-4") echo "selected=selected"; ?>><?php _e('3 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-md-3" <?php if($col_desktops == "col-md-3") echo "selected=selected"; ?>><?php _e('4 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-md-2" <?php if($col_desktops == "col-md-2") echo "selected=selected"; ?>><?php _e('6 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-md-1" <?php if($col_desktops == "col-md-1") echo "selected=selected"; ?>><?php _e('12 Column', 'portfolio-filter-gallery'); ?></option>
										</select>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Columns On Mobile (Landscape)', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Set columns for tablet', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<div class="switch-field em_size_field">
										<?php if(isset($pf_gallery_settings['col_tablets'])) $col_tablets = $pf_gallery_settings['col_tablets']; else $col_tablets = "col-sm-4"; ?>
										<select id="col_tablets" name="col_tablets" class="selectbox_settings form-control">
											<option value="col-sm-12" <?php if($col_tablets == "col-sm-12") echo "selected=selected"; ?>><?php _e('1 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-sm-6" <?php if($col_tablets == "col-sm-6") echo "selected=selected"; ?>><?php _e('2 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-sm-4" <?php if($col_tablets == "col-sm-4") echo "selected=selected"; ?>><?php _e('3 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-sm-3" <?php if($col_tablets == "col-sm-3") echo "selected=selected"; ?>><?php _e('4 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-sm-2" <?php if($col_tablets == "col-sm-2") echo "selected=selected"; ?>><?php _e('6 Column', 'portfolio-filter-gallery'); ?></option>
										</select>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Columns On Mobile (Portrait)', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Set columns for phone', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<div class="switch-field em_size_field">
										<?php if(isset($pf_gallery_settings['col_phones'])) $col_phones = $pf_gallery_settings['col_phones']; else $col_phones = "col-6"; ?>
										<select id="col_phones" name="col_phones" class="selectbox_settings form-control">
											<option value="col-12" <?php if($col_phones == "col-12") echo "selected=selected"; ?>><?php _e('1 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-6" <?php if($col_phones == "col-6") echo "selected=selected"; ?>><?php _e('2 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-4" <?php if($col_phones == "col-4") echo "selected=selected"; ?>><?php _e('3 Column', 'portfolio-filter-gallery'); ?></option>
											<option value="col-3" <?php if($col_phones == "col-3") echo "selected=selected"; ?>><?php _e('4 Column', 'portfolio-filter-gallery'); ?></option>
										</select>
									</div>
								</div>
							</div>
						</div>
					</div>
					
					<div class="row">
					<div class="col-md-4">
						<div class="ma_field_discription">
							<h4><?php _e('Gallery Direction', 'portfolio-filter-gallery'); ?></h4>
							<p><?php _e('Gallery Direction', 'portfolio-filter-gallery'); ?></p> 
						</div>
					</div>
					<div class="col-md-8">
						<div class="ma_field panel-body">
							<p class="switch-field em_size_field">
							<?php if(isset($pf_gallery_settings['gallery_direction'])) $gallery_direction = $pf_gallery_settings['gallery_direction']; else $gallery_direction = "ltr"; ?>
							<input type="radio" name="gallery_direction" id="gallery_direction1" value="rtl" <?php if($gallery_direction == "rtl") echo "checked=checked"; ?>>
							<label for="gallery_direction1"><?php _e('RTL', 'portfolio-filter-gallery'); ?></label>
							<input type="radio" name="gallery_direction" id="gallery_direction2" value="ltr" <?php if($gallery_direction == "ltr") echo "checked=checked"; ?>>
							<label for="gallery_direction2"><?php _e('LTR', 'portfolio-filter-gallery'); ?></label>
							</p>
						</div>
					</div>
				</div>
					
					<!--Theme 1 Hover-->
					<div class="theme1_hover">
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Image Hover Effects', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Choose Image Hover Effects', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<div class="col-md-9">
									<p class="switch-field em_size_field hover_field">
										<?php if(isset($pf_gallery_settings['image_hover_effect_theme2'])) $image_hover_effect_theme2 = $pf_gallery_settings['image_hover_effect_theme2']; else $image_hover_effect_theme2 = "overlay_zoom"; ?>
										<input type="radio" name="image_hover_effect_theme2" id="image_hover_effect_t1" value="no" <?php if($image_hover_effect_theme2 == "no") echo "checked=checked"; ?>>
										<label for="image_hover_effect_t1"><?php _e('None', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="image_hover_effect_theme2" id="image_hover_effect_2d" value="2d" <?php if($image_hover_effect_theme2 == "2d") echo "checked=checked"; ?>>
										<label for="image_hover_effect_2d"><?php _e('2D Transitions', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="image_hover_effect_theme2" id="image_hover_effect_t2" value="overlay_zoom" <?php if($image_hover_effect_theme2 == "overlay_zoom") echo "checked=checked"; ?>>
										<label style for="image_hover_effect_t2"><?php _e('Overlay Zoom', 'portfolio-filter-gallery'); ?></label>
									</p>
									</div>
									<!-- 2d -->
									<div class="he_2d">
										<?php if(isset($pf_gallery_settings['image_hover_effect_one_2d'])) $image_hover_effect_one_2d = $pf_gallery_settings['image_hover_effect_one_2d']; else $image_hover_effect_one_2d = "hvr-buzz"; ?>
										<select name="image_hover_effect_one_2d" id="image_hover_effect_one_2d" class="selectbox_settings">
											<optgroup label="2D Transitions Effects" class="2d">
												<option value="hvr-grow" <?php if($image_hover_effect_one_2d == "hvr-grow") echo "selected=selected"; ?>>Grow</option>
												<option value="hvr-shrink" <?php if($image_hover_effect_one_2d == "hvr-shrink") echo "selected=selected"; ?>>Shrink</option>
												<option value="hvr-pulse" <?php if($image_hover_effect_one_2d == "hvr-pulse") echo "selected=selected"; ?>>Pulse</option>
												<option value="hvr-pulse-grow" <?php if($image_hover_effect_one_2d == "hvr-pulse-grow") echo "selected=selected"; ?>>Pulse Grow</option>
												<option value="hvr-pulse-shrink" <?php if($image_hover_effect_one_2d == "hvr-pulse-shrink") echo "selected=selected"; ?>>Pulse Shrink</option>
												<option value="hvr-push" <?php if($image_hover_effect_one_2d == "hvr-push") echo "selected=selected"; ?>>Push</option>
												<option value="hvr-pop" <?php if($image_hover_effect_one_2d == "hvr-pop") echo "selected=selected"; ?>>Pop</option>
												<option value="hvr-bounce-in" <?php if($image_hover_effect_one_2d == "hvr-bounce-in") echo "selected=selected"; ?>>Bounce In</option>
												<option value="hvr-bounce-out" <?php if($image_hover_effect_one_2d == "hvr-bounce-out") echo "selected=selected"; ?>>Bounce Out</option>
												<option value="hvr-rotate" <?php if($image_hover_effect_one_2d == "hvr-rotate") echo "selected=selected"; ?>>Rotate</option>
												<option value="hvr-grow-rotate" <?php if($image_hover_effect_one_2d == "hvr-grow-rotate") echo "selected=selected"; ?>>Grow Rotate</option>
												<option value="hvr-float" <?php if($image_hover_effect_one_2d == "hvr-float") echo "selected=selected"; ?>>Float</option>
												<option value="hvr-sink" <?php if($image_hover_effect_one_2d == "hvr-sink") echo "selected=selected"; ?>>Sink</option>
												<option value="hvr-bob" <?php if($image_hover_effect_one_2d == "hvr-bob") echo "selected=selected"; ?>>Bob</option>
												<option value="hvr-hang" <?php if($image_hover_effect_one_2d == "hvr-hang") echo "selected=selected"; ?>>Hang</option>
												<option value="hvr-skew" <?php if($image_hover_effect_one_2d == "hvr-skew") echo "selected=selected"; ?>>Skew</option>
												<option value="hvr-skew-forward" <?php if($image_hover_effect_one_2d == "hvr-skew-forward") echo "selected=selected"; ?>>Skew Forward</option>
												<option value="hvr-skew-backward" <?php if($image_hover_effect_one_2d == "hvr-skew-backward") echo "selected=selected"; ?>>Skew Backward</option>
												<option value="hvr-wobble-horizontal" <?php if($image_hover_effect_one_2d == "hvr-wobble-horizontal") echo "selected=selected"; ?>>Wobble Horizontal</option>
												<option value="hvr-wobble-vertical" <?php if($image_hover_effect_one_2d == "hvr-wobble-vertical") echo "selected=selected"; ?>>Wobble Vertical</option>
												<option value="hvr-wobble-to-bottom-right" <?php if($image_hover_effect_one_2d == "hvr-wobble-to-bottom-right") echo "selected=selected"; ?>>Wobble to Bottom Right</option>
												<option value="hvr-wobble-to-top-right" <?php if($image_hover_effect_one_2d == "hvr-wobble-to-top-right") echo "selected=selected"; ?>>Wobble to Top Right</option>
												<option value="hvr-wobble-top" <?php if($image_hover_effect_one_2d == "hvr-wobble-top") echo "selected=selected"; ?>>Wobble Top</option>
												<option value="hvr-wobble-bottom" <?php if($image_hover_effect_one_2d == "hvr-wobble-bottom") echo "selected=selected"; ?>>Wobble Bottom</option>
												<option value="hvr-wobble-skew" <?php if($image_hover_effect_one_2d == "hvr-wobble-skew") echo "selected=selected"; ?>>Wobble Skew</option>
												<option value="hvr-buzz" <?php if($image_hover_effect_one_2d == "hvr-buzz") echo "selected=selected"; ?>>Buzz</option>
												<option value="hvr-buzz-out" <?php if($image_hover_effect_one_2d == "hvr-buzz-out") echo "selected=selected"; ?>>Buzz Out</option>
											</optgroup>
										</select>
									</div>
									<!-- overlay_zoom -->
									<div class="he_overlay">
										<?php if(isset($pf_gallery_settings['image_hover_effect_two'])) $image_hover_effect_two = $pf_gallery_settings['image_hover_effect_two']; else $image_hover_effect_two = "overlay_zoom"; ?>
										<select name="image_hover_effect_two" id="image_hover_effect_two" class="selectbox_settings">
											<optgroup label="Image Overlay With Zoom Effect" class="sg">
												<option value="overlay_zoom" <?php if($image_hover_effect_two == "overlay_zoom") echo "selected=selected"; ?>><?php _e('Overlay Zoom', 'portfolio-filter-gallery'); ?></option>
												<option value="img_title_cap" <?php if($image_hover_effect_two == "img_title_cap") echo "selected=selected"; ?>><?php _e('Image with title & caption on hover', 'portfolio-filter-gallery'); ?></option>
												<option value="img_title_slide" <?php if($image_hover_effect_two == "img_title_slide") echo "selected=selected"; ?>><?php _e('Image with title and slide in icon on hover', 'portfolio-filter-gallery'); ?></option>
											</optgroup>
										</select>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!--Theme 2 Hover-->
					<div class="row theme2_hover">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Image Hover Effects', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Choose Image Hover Effects', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<div class="pfg_spacing_md">
									<!--Theme 1-->
									<p class="switch-field em_size_field hover_field">
										<?php if(isset($pf_gallery_settings['image_hover_effect_type'])) $image_hover_effect_type = $pf_gallery_settings['image_hover_effect_type']; else $image_hover_effect_type = "2d"; ?>
										<input type="radio" name="image_hover_effect_type" id="image_hover_effect_type1" value="no" <?php if($image_hover_effect_type == "no") echo "checked=checked"; ?>>
										<label for="image_hover_effect_type1"><?php _e('None', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="image_hover_effect_type" id="image_hover_effect_type2" value="2d" <?php if($image_hover_effect_type == "2d") echo "checked=checked"; ?>>
										<label for="image_hover_effect_type2"><?php _e('2D Transitions', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="image_hover_effect_type" id="image_hover_effect_type3" value="sg" <?php if($image_hover_effect_type == "sg") echo "checked=checked"; ?>>
										<label for="image_hover_effect_type3"><?php _e('Shadow & Glow', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
								<!-- 1 -->
								<div class="he_one">
									<label class="pfg_label_settings"><?php _e('Image Hover Effects', 'portfolio-filter-gallery'); ?></label><br><br>
									<?php if(isset($pf_gallery_settings['image_hover_effect_one'])) $image_hover_effect_one = $pf_gallery_settings['image_hover_effect_one']; else $image_hover_effect_one = "hvr-buzz"; ?>
									<select name="image_hover_effect_one" id="image_hover_effect_one" class="selectbox_settings">
										<optgroup label="2D Transitions Effects" class="2d">
											<option value="hvr-grow" <?php if($image_hover_effect_one == "hvr-grow") echo "selected=selected"; ?>><?php _e('Grow', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-shrink" <?php if($image_hover_effect_one == "hvr-shrink") echo "selected=selected"; ?>><?php _e('Shrink', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-pulse" <?php if($image_hover_effect_one == "hvr-pulse") echo "selected=selected"; ?>><?php _e('Pulse', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-pulse-grow" <?php if($image_hover_effect_one == "hvr-pulse-grow") echo "selected=selected"; ?>><?php _e('Pulse Grow', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-pulse-shrink" <?php if($image_hover_effect_one == "hvr-pulse-shrink") echo "selected=selected"; ?>><?php _e('Pulse Shrink', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-push" <?php if($image_hover_effect_one == "hvr-push") echo "selected=selected"; ?>><?php _e('Push', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-pop" <?php if($image_hover_effect_one == "hvr-pop") echo "selected=selected"; ?>><?php _e('Pop', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-bounce-in" <?php if($image_hover_effect_one == "hvr-bounce-in") echo "selected=selected"; ?>><?php _e('Bounce In', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-bounce-out" <?php if($image_hover_effect_one == "hvr-bounce-out") echo "selected=selected"; ?>><?php _e('Bounce Out', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-rotate" <?php if($image_hover_effect_one == "hvr-rotate") echo "selected=selected"; ?>><?php _e('Rotate', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-grow-rotate" <?php if($image_hover_effect_one == "hvr-grow-rotate") echo "selected=selected"; ?>><?php _e('Grow Rotate', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-float" <?php if($image_hover_effect_one == "hvr-float") echo "selected=selected"; ?>><?php _e('Float', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-sink" <?php if($image_hover_effect_one == "hvr-sink") echo "selected=selected"; ?>><?php _e('Sink', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-bob" <?php if($image_hover_effect_one == "hvr-bob") echo "selected=selected"; ?>><?php _e('Bob', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-hang" <?php if($image_hover_effect_one == "hvr-hang") echo "selected=selected"; ?>><?php _e('Hang', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-skew" <?php if($image_hover_effect_one == "hvr-skew") echo "selected=selected"; ?>><?php _e('Skew', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-skew-forward" <?php if($image_hover_effect_one == "hvr-skew-forward") echo "selected=selected"; ?>><?php _e('Skew Forward', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-skew-backward" <?php if($image_hover_effect_one == "hvr-skew-backward") echo "selected=selected"; ?>><?php _e('Skew Backward', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-wobble-horizontal" <?php if($image_hover_effect_one == "hvr-wobble-horizontal") echo "selected=selected"; ?>><?php _e('Wobble Horizontal', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-wobble-vertical" <?php if($image_hover_effect_one == "hvr-wobble-vertical") echo "selected=selected"; ?>><?php _e('Wobble Vertical', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-wobble-to-bottom-right" <?php if($image_hover_effect_one == "hvr-wobble-to-bottom-right") echo "selected=selected"; ?>><?php _e('Wobble to Bottom Right', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-wobble-to-top-right" <?php if($image_hover_effect_one == "hvr-wobble-to-top-right") echo "selected=selected"; ?>><?php _e('Wobble to Top Right', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-wobble-top" <?php if($image_hover_effect_one == "hvr-wobble-top") echo "selected=selected"; ?>><?php _e('Wobble Top', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-wobble-bottom" <?php if($image_hover_effect_one == "hvr-wobble-bottom") echo "selected=selected"; ?>><?php _e('Wobble Bottom', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-wobble-skew" <?php if($image_hover_effect_one == "hvr-wobble-skew") echo "selected=selected"; ?>><?php _e('Wobble Skew', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-buzz" <?php if($image_hover_effect_one == "hvr-buzz") echo "selected=selected"; ?>><?php _e('Buzz', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-buzz-out" <?php if($image_hover_effect_one == "hvr-buzz-out") echo "selected=selected"; ?>><?php _e('Buzz Out', 'portfolio-filter-gallery'); ?></option>
										</optgroup>
									</select>
								</div>
								<!-- 4 -->
								<div class="he_four">
									<label class="pfg_label_settings"><?php _e('Image Hover Effects', 'portfolio-filter-gallery'); ?></label><br><br>
									<?php if(isset($pf_gallery_settings['image_hover_effect_four'])) $image_hover_effect_four = $pf_gallery_settings['image_hover_effect_four']; else $image_hover_effect_four = "hvr-box-shadow-outset"; ?>
									<select name="image_hover_effect_four" id="image_hover_effect_four" class="selectbox_settings">
										<optgroup label="Shadow and Glow Transitions Effects" class="sg">
											<option value="hvr-grow-shadow" <?php if($image_hover_effect_four == "hvr-grow-shadow") echo "selected=selected"; ?>><?php _e('Grow Shadow', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-float-shadow" <?php if($image_hover_effect_four == "hvr-float-shadow") echo "selected=selected"; ?>><?php _e('Float Shadow', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-glow" <?php if($image_hover_effect_four == "hvr-glow") echo "selected=selected"; ?>><?php _e('Glow', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-box-shadow-outset" <?php if($image_hover_effect_four == "hvr-box-shadow-outset") echo "selected=selected"; ?>><?php _e('Box Shadow Outset', 'portfolio-filter-gallery'); ?></option>
											<option value="hvr-box-shadow-inset" <?php if($image_hover_effect_four == "hvr-box-shadow-inset") echo "selected=selected"; ?>><?php _e('Box Shadow Inset', 'portfolio-filter-gallery'); ?></option>
										</optgroup>
									</select>
								</div>
							</div>
						</div>
					</div>
					<!--Theme 1 Thumbnail seting-->
					<div class="theme1_thumb">
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Title & description On Thumbnail', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Title & description On Thumbnail', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">
										<?php if(isset($pf_gallery_settings['title_thumb'])) $title_thumb = $pf_gallery_settings['title_thumb']; else $title_thumb = "show"; ?>
										<input type="radio" name="title_thumb" id="title_thumb1" value="show" <?php if($title_thumb == "show") echo "checked=checked"; ?>>
										<label for="title_thumb1"><?php _e('Show', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="title_thumb" id="title_thumb2" value="hide" <?php if($title_thumb == "hide") echo "checked=checked"; ?>>
										<label for="title_thumb2"><?php _e('Hide', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
						</div>
						<div class="title_set">
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Title & description Color', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Title & description Color', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body">
										<?php if(isset($pf_gallery_settings['title_color'])) $title_color = $pf_gallery_settings['title_color']; else $title_color = '#000000'; ?>
										<input type="text" class="form-control" id="title_color" name="title_color" placeholder="chose form color" value="<?php echo $title_color; ?>" default-color="<?php echo $title_color; ?>">
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Title & description Background Color', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Title & description Background Color', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body">
										<?php if(isset($pf_gallery_settings['title_bg_color'])) $title_bg_color = $pf_gallery_settings['title_bg_color']; else $title_bg_color = '#edeef0'; ?>
										<input type="text" class="form-control" id="title_bg_color" name="title_bg_color" placeholder="chose form color" value="<?php echo $title_bg_color; ?>" default-color="<?php echo $title_bg_color; ?>">
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Title Font Size', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Title Font Size', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body range-slider">
										<?php if(isset($pf_gallery_settings['title_size2'])) $title_size2 = $pf_gallery_settings['title_size2']; else $title_size2 = 20; ?>
										<input id="title_size2" name="title_size2" class="range-slider__range" type="range" value="<?php echo $title_size2; ?>" min="14" max="32" step="2" style="width: 300px !important;  ">
										<span class="range-slider__value">0</span>
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Read More', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Read More', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">
									<?php if(isset($pf_gallery_settings['pfg_read_more'])) $pfg_read_more = $pf_gallery_settings['pfg_read_more']; else $pfg_read_more = "show"; ?>
									<input type="radio" name="pfg_read_more" id="pfg_read_more1" value="show" <?php if($pfg_read_more == "show") echo "checked=checked"; ?>>
									<label for="pfg_read_more1"><?php _e('Show', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="pfg_read_more" id="pfg_read_more2" value="hide" <?php if($pfg_read_more == "hide") echo "checked=checked"; ?>>
									<label for="pfg_read_more2"><?php _e('Hide', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Link on image', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Option for link on image', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">
									<?php if(isset($pf_gallery_settings['link_on_img'])) $link_on_img = $pf_gallery_settings['link_on_img']; else $link_on_img = "yes"; ?>
									<input type="radio" name="link_on_img" id="link_on_img1" value="yes" <?php if($link_on_img == "yes") echo "checked=checked"; ?>>
									<label for="link_on_img1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="link_on_img" id="link_on_img2" value="no" <?php if($link_on_img == "no") echo "checked=checked"; ?>>
									<label for="link_on_img2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
						</div>
						<div class="row read_more_txt">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Change Read More Text', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Change Read More Text', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['read_txt'])) $read_txt = $pf_gallery_settings['read_txt']; else $read_txt = 'Read More'; ?>
									<input type="text" class="selectbox_settings sort form-control" id="read_txt" name="read_txt" value="<?php echo $read_txt; ?>">
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Thumbnails Custom Border Setting', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Thumbnails Custom Border Setting', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">
									<?php if(isset($pf_gallery_settings['border_hide'])) $border_hide = $pf_gallery_settings['border_hide']; else $border_hide = 0; ?>
									<input type="radio" name="border_hide" id="border_hide1" value="1" <?php if($border_hide == 1) echo "checked=checked"; ?>>
									<label for="border_hide1"><?php _e('Show', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="border_hide" id="border_hide2" value="0" <?php if($border_hide == 0) echo "checked=checked"; ?>>
									<label for="border_hide2"><?php _e('Hide', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
						</div>
						<div class="border_settings">
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Image Border Size', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Image Border Size', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body range-slider">
										<?php if(isset($pf_gallery_settings['border_size'])) $border_size = $pf_gallery_settings['border_size']; else $border_size = 0; ?>
										<input id="border_size" name="border_size" class="range-slider__range" type="range" value="<?php echo $border_size; ?>" min="0" max="10" step="1" style="width: 300px !important;">
										<span class="range-slider__value">0</span>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Image Border Color', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Image Border Color', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body">
										<?php if(isset($pf_gallery_settings['border_color'])) $border_color = $pf_gallery_settings['border_color']; else $border_color = '#FFFFFF'; ?>
										<input type="text" class="form-control" id="border_color" name="border_color" placeholder="chose form color" value="<?php echo $border_color; ?>" default-color="<?php echo $border_color; ?>">
									</div>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Show Numbering On Thumbnails', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Show Numbering On Thumbnails', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">
									<?php if(isset($pf_gallery_settings['image_numbering'])) $image_numbering = $pf_gallery_settings['image_numbering']; else $image_numbering = "0"; ?>
									<input type="radio" name="image_numbering" id="image_numbering1" value="1" <?php if($image_numbering == 1) echo "checked=checked"; ?>>
									<label for="image_numbering1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="image_numbering" id="image_numbering2" value="0" <?php if($image_numbering == 0) echo "checked=checked"; ?>>
									<label for="image_numbering2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Thumbnails Spacing', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Thumbnails Spacing', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field range-slider">		
										<?php if(isset($pf_gallery_settings['thumb_spacing'])) $thumb_spacing = $pf_gallery_settings['thumb_spacing']; else $thumb_spacing = 2; ?>
										<input id="thumb_spacing" name="thumb_spacing" class="range-slider__range" type="range" value="<?php echo $thumb_spacing; ?>" min="0" max="12" step="2" style="width: 300px !important;  ">
										<span class="range-slider__value">0</span>
									</p>
								</div>
							</div>
						</div>
					</div>
					
					<!--Theme 2 Thumbnail setting-->
					<div class="theme2_thumb">
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Thumbnails Spacing', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Thumbnails Spacing', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field range-slider">		
										<?php if(isset($pf_gallery_settings['thumb_spacing2'])) $thumb_spacing2 = $pf_gallery_settings['thumb_spacing2']; else $thumb_spacing2 = 2; ?>
										<input id="thumb_spacing2" name="thumb_spacing2" class="range-slider__range" type="range" value="<?php echo $thumb_spacing2; ?>" min="0" max="12" step="2" style="width: 300px !important;  ">
										<span class="range-slider__value">0</span>
									</p>
								</div>
							</div>
						</div>
						
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Title & description On Thumbnail', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Title & description On Thumbnail', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">
										<?php if(isset($pf_gallery_settings['title_thumb2'])) $title_thumb2 = $pf_gallery_settings['title_thumb2']; else $title_thumb2 = "show"; ?>
										<input type="radio" name="title_thumb2" id="title_thumb11" value="show" <?php if($title_thumb2 == "show") echo "checked=checked"; ?>>
										<label for="title_thumb11"><?php _e('Show', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="title_thumb2" id="title_thumb22" value="hide" <?php if($title_thumb2 == "hide") echo "checked=checked"; ?>>
										<label for="title_thumb22"><?php _e('Hide', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
						</div>
						
						<div class="title_set2">
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Title Color', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Title Color', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body">
										<?php if(isset($pf_gallery_settings['title_color2'])) $title_color2 = $pf_gallery_settings['title_color2']; else $title_color2 = '#FFFFFF'; ?>
										<input type="text" class="form-control" id="title_color2" name="title_color2" placeholder="chose form color" value="<?php echo $title_color2; ?>" default-color="<?php echo $title_color2; ?>">
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Title Background Color', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Title Background Color', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body">
										<?php if(isset($pf_gallery_settings['title_bg_color2'])) $title_bg_color2 = $pf_gallery_settings['title_bg_color2']; else $title_bg_color2 = 1; ?>
										<input type="text" class="form-control" id="title_bg_color2" name="title_bg_color2" placeholder="chose form color" value="<?php echo $title_bg_color2; ?>" default-color="<?php echo $title_bg_color2; ?>">
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Title Background Color Opacity', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Title Background Color Opacity', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body">
										<?php if(isset($pf_gallery_settings['title_bg_opacity'])) $title_bg_opacity = $pf_gallery_settings['title_bg_opacity']; else $title_bg_opacity = '1'; ?>
										<input id="title_bg_opacity" name="title_bg_opacity" class="range-slider__range" type="range" value="<?php echo $title_bg_opacity; ?>" min="0" max="1" step="0.1" style="width: 300px !important; ">
										<span class="range-slider__value">0</span>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-md-4">
									<div class="ma_field_discription">
										<h4><?php _e('Title Font Size', 'portfolio-filter-gallery'); ?></h4>
										<p><?php _e('Title Font Size', 'portfolio-filter-gallery'); ?></p> 
									</div>
								</div>
								<div class="col-md-8">
									<div class="ma_field panel-body">
										<?php if(isset($pf_gallery_settings['title_size'])) $title_size = $pf_gallery_settings['title_size']; else $title_size = 20; ?>
										<input id="title_size" name="title_size" class="range-slider__range" type="range" value="<?php echo $title_size; ?>" min="14" max="32" step="2" style="width: 300px !important;  ">
										<span class="range-slider__value">0</span>
									</div>
								</div>
							</div>
						</div>
						
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Thumbnails Custom Border Setting', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Thumbnails Custom Border Setting', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">		
										<?php if(isset($pf_gallery_settings['border_hide2'])) $border_hide2 = $pf_gallery_settings['border_hide2']; else $border_hide2 = 0; ?>
										<input type="radio" name="border_hide2" id="border_hidet1" value="1" <?php if($border_hide2 == 1) echo "checked=checked"; ?>>
										<label for="border_hidet1"><?php _e('Show', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="border_hide2" id="border_hidet2" value="0" <?php if($border_hide2 == 0) echo "checked=checked"; ?>>
										<label for="border_hidet2"><?php _e('Hide', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Image Border Size', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Image Border Size', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['border_size2'])) $border_size2 = $pf_gallery_settings['border_size2']; else $border_size2 = 0; ?>
									<input id="border_size2" name="border_size2" class="range-slider__range" type="range" value="<?php echo $border_size2; ?>" min="0" max="10" step="1" style="width: 300px !important;  ">
									<span class="range-slider__value">0</span>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Image Border Color', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Image Border Color', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['border_color2'])) $border_color2 = $pf_gallery_settings['border_color2']; else $border_color2 = '#FFFFFF'; ?>
									<input type="text" class="form-control" id="border_color2" name="border_color2" placeholder="chose form color" value="<?php echo $border_color2; ?>" default-color="<?php echo $border_color2; ?>">
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Show Numbering On Thumbnails', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Show Numbering On Thumbnails', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">		
										<?php if(isset($pf_gallery_settings['image_numbering2'])) $image_numbering2 = $pf_gallery_settings['image_numbering2']; else $image_numbering2 = "1"; ?>
										<input type="radio" name="image_numbering2" id="image_numberingt1" value="1" <?php if($image_numbering2 == 1) echo "checked=checked"; ?>>
										<label for="image_numberingt1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="image_numbering2" id="image_numberingt2" value="0" <?php if($image_numbering2 == 0) echo "checked=checked"; ?>>
										<label for="image_numberingt2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Hide Thumbnails Spacing', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Hide Thumbnails Spacing', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<p class="switch-field em_size_field">		
										<?php if(isset($pf_gallery_settings['no_spacing'])) $no_spacing = $pf_gallery_settings['no_spacing']; else $no_spacing = 0; ?>
										<input type="radio" name="no_spacing" id="no_spacing1" value="1" <?php if($no_spacing == 1) echo "checked=checked"; ?>>
										<label for="no_spacing1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
										<input type="radio" name="no_spacing" id="no_spacing2" value="0" <?php if($no_spacing == 0) echo "checked=checked"; ?>>
										<label for="no_spacing2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
									</p>
								</div>
							</div>
						</div>
					</div>
					
					<!--URL Gray Scale-->
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Image Gray Scale', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Image Gray Scale', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field">
									<?php if(isset($pf_gallery_settings['gray_scale'])) $gray_scale = $pf_gallery_settings['gray_scale']; else $gray_scale = 0; ?>
									<input type="radio" name="gray_scale" id="gray_scale1" value="1" <?php if($gray_scale == 1) echo "checked=checked"; ?>>
									<label for="gray_scale1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="gray_scale" id="gray_scale2" value="0" <?php if($gray_scale == 0) echo "checked=checked"; ?>>
									<label for="gray_scale2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Video Auto-Play In Lightbox', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Video Auto-Play In Lightbox', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field">
									<?php if(isset($pf_gallery_settings['video_auto_play'])) $video_auto_play = $pf_gallery_settings['video_auto_play']; else $video_auto_play = 0; ?>
									<input type="radio" name="video_auto_play" id="video_auto_play1" value="1" <?php if($video_auto_play == 1) echo "checked=checked"; ?>>
									<label for="video_auto_play1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="video_auto_play" id="video_auto_play2" value="0" <?php if($video_auto_play == 0) echo "checked=checked"; ?>>
									<label for="video_auto_play2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Open Image Link URL', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Open Image Link URL', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field hover_field">		
									<?php if(isset($pf_gallery_settings['url_target'])) $url_target = $pf_gallery_settings['url_target']; else $url_target = "_blank"; ?>
									<input type="radio" name="url_target" id="url_target1" value="_blank" <?php if($url_target == "_blank") echo "checked=checked"; ?>>
									<label for="url_target1"><?php _e('Into New Tab', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="url_target" id="url_target2" value="_self" <?php if($url_target == "_self") echo "checked=checked"; ?>>
									<label for="url_target2"><?php _e('Into Same Tab', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Link Nofollow', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Link Attribute Nofollow', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field hover_field">		
									<?php if(isset($pf_gallery_settings['link_nofollow'])) $link_nofollow = $pf_gallery_settings['link_nofollow']; else $link_nofollow = "nofollow"; ?>
									<input type="radio" name="link_nofollow" id="link_nofollow1" value="nofollow" <?php if($link_nofollow == "nofollow") echo "checked=checked"; ?>>
									<label for="link_nofollow1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="link_nofollow" id="link_nofollow2" value="" <?php if($link_nofollow == "") echo "checked=checked"; ?>>
									<label for="link_nofollow2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Link Noopener', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Link Attribute Noopener', 'portfolio-filter-gallery'); ?></p>
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field hover_field">		
									<?php if(isset($pf_gallery_settings['link_noopener'])) $link_noopener = $pf_gallery_settings['link_noopener']; else $link_noopener = "noopener"; ?>
									<input type="radio" name="link_noopener" id="link_noopener1" value="noopener" <?php if($link_noopener == "noopener") echo "checked=checked"; ?>>
									<label for="link_noopener1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="link_noopener" id="link_noopener2" value="" <?php if($link_noopener == "") echo "checked=checked"; ?>>
									<label for="link_noopener2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Link Noreferrer', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Link Attribute Noreferrer', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field hover_field">		
									<?php if(isset($pf_gallery_settings['link_noreferrer'])) $link_noreferrer = $pf_gallery_settings['link_noreferrer']; else $link_noreferrer = "noreferrer"; ?>
									<input type="radio" name="link_noreferrer" id="link_noreferrer1" value="noreferrer" <?php if($link_noreferrer == "noreferrer") echo "checked=checked"; ?>>
									<label for="link_noreferrer1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
									<input type="radio" name="link_noreferrer" id="link_noreferrer2" value="" <?php if($link_noreferrer == "") echo "checked=checked"; ?>>
									<label for="link_noreferrer2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
					<div class="col-md-4">
						<div class="ma_field_discription">
							<h4><?php _e('Disable Bootstrap JS For Output', 'portfolio-filter-gallery'); ?></h4>
							<p><?php _e('You can disable bootstrap js for ourput if you have problem with it.', 'portfolio-filter-gallery'); ?></p> 
						</div>
					</div>
					<div class="col-md-8">
						<div class="ma_field panel-body">
							<p class="switch-field em_size_field">
								<?php if(isset($pf_gallery_settings['bootstrap_disable'])) $bootstrap_disable = $pf_gallery_settings['bootstrap_disable']; else $bootstrap_disable = "no"; ?>
								<input type="radio" name="bootstrap_disable" id="bootstrap_disable1" value="yes" <?php if($bootstrap_disable == "yes") echo "checked=checked"; ?>>
								<label for="bootstrap_disable1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="bootstrap_disable" id="bootstrap_disable2" value="no" <?php if($bootstrap_disable == "no") echo "checked=checked"; ?>>
								<label for="bootstrap_disable2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
							</p>
						</div>
					</div>
				</div>
				</div>
			</div>
			<div class="bhoechie-tab-content">
				<h1><?php _e('Filters And Sorting controls Settings', 'portfolio-filter-gallery'); ?></h1>
				<hr>
				<div class="row">
					<div class="col-md-4">
						<div class="ma_field_discription">
							<h4><?php _e('Hide filters', 'portfolio-filter-gallery'); ?></h4>
							<p><?php _e('Hide filters', 'portfolio-filter-gallery'); ?></p> 
						</div>
					</div>
					<div class="col-md-8">
						<div class="ma_field panel-body">
							<?php if(isset($pf_gallery_settings['hide_filters'])) $hide_filters = $pf_gallery_settings['hide_filters']; else $hide_filters = 0; ?>
							<p class="switch-field em_size_field">
							<input type="radio" name="hide_filters" id="hide_filters1" value="1" <?php if($hide_filters == 1) echo "checked=checked"; ?>>
							<label for="hide_filters1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
							<input type="radio" name="hide_filters" id="hide_filters2" value="0" <?php if($hide_filters == 0) echo "checked=checked"; ?>>
							<label for="hide_filters2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
							</p>
						</div>
					</div>
				</div>
				<div class="filters_section">
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e("Hide 'All' Button", 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e("Hide 'All' Button", 'portfolio-filter-gallery'); ?></p>
							</div>
						</div>
						<div class="col-md-8">
							
							<div class="ma_field panel-body">
								<?php if(isset($pf_gallery_settings['hide_all_button'])) $hide_all_button = $pf_gallery_settings['hide_all_button']; else $hide_all_button = 0; ?>
								<p class="switch-field em_size_field">
								<input type="radio" name="hide_all_button" id="hide_all_button1" value="1" <?php if($hide_all_button == 1) echo "checked=checked"; ?>>
								<label for="hide_all_button1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="hide_all_button" id="hide_all_button2" value="0" <?php if($hide_all_button == 0) echo "checked=checked"; ?>>
								<label for="hide_all_button2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Text For "All" Filter', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Text for "All" filter', 'portfolio-filter-gallery'); ?></p>
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<?php if(isset($pf_gallery_settings['all_txt'])) $all_txt = $pf_gallery_settings['all_txt']; else $all_txt = 'All'; ?>
								<input type="text" class="selectbox_settings sort" id="all_txt" name="all_txt" value="<?php echo $all_txt; ?>">
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Sort Filter In Alphabatic Order', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Sort Filter In Alphabatic Order', 'portfolio-filter-gallery'); ?></p>
							</div>
						</div>
						<div class="col-md-8">
							
							<div class="ma_field panel-body">
								<?php if(isset($pf_gallery_settings['sort_filter_order'])) $sort_filter_order = $pf_gallery_settings['sort_filter_order']; else $sort_filter_order = 0; ?>
								<p class="switch-field em_size_field">
								<input type="radio" name="sort_filter_order" id="sort_filter_order1" value="1" <?php if($sort_filter_order == 1) echo "checked=checked"; ?>>
								<label for="sort_filter_order1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="sort_filter_order" id="sort_filter_order2" value="0" <?php if($sort_filter_order == 0) echo "checked=checked"; ?>>
								<label for="sort_filter_order2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Filters Style', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Choose Filters Style', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8 ">
							<div class="ma_field panel-body">
								<?php if(isset($pf_gallery_settings['pfg_filter_style'])) $pfg_filter_style = $pf_gallery_settings['pfg_filter_style']; else $pfg_filter_style = "pfg_filter_style1"; ?>
								<div class="col-md-4" style="padding:0;">
									<select id="pfg_filter_style" name="pfg_filter_style" class="selectbox_settings form-control" style="width:100% !important; padding:0;">
										<option value="pfg_filter_style1" <?php if($pfg_filter_style == "pfg_filter_style1") echo "selected=selected"; ?>> <?php _e('Style 1', 'portfolio-filter-gallery'); ?></option>
										<option value="pfg_filter_style2" <?php if($pfg_filter_style == "pfg_filter_style2") echo "selected=selected"; ?>> <?php _e('Style 2', 'portfolio-filter-gallery'); ?></option>
										<option value="pfg_filter_style3" <?php if($pfg_filter_style == "pfg_filter_style3") echo "selected=selected"; ?>> <?php _e('Style 3', 'portfolio-filter-gallery'); ?></option>
										<option value="pfg_filter_style4" <?php if($pfg_filter_style == "pfg_filter_style4") echo "selected=selected"; ?>> <?php _e('Style 4', 'portfolio-filter-gallery'); ?></option>
									</select>
								</div>
								<div class="col-md-8">
									<img class="pfg_filter_style1" style="box-shadow:0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);" src="<?php echo PFG_PLUGIN_URL ?>/img/filter-style-1.png"/>
									<img class="pfg_filter_style2" style="box-shadow:0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);" src="<?php echo PFG_PLUGIN_URL ?>/img/filter-style-2.png"/>
									<img class="pfg_filter_style3" style="box-shadow:0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);" src="<?php echo PFG_PLUGIN_URL ?>/img/filter-style-3.png"/>
									<img class="pfg_filter_style4" style="box-shadow:0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19); width:536px" src="<?php echo PFG_PLUGIN_URL ?>/img/filter-style-4.png"/>
								</div>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Filters Position', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Choose Filters Position', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8 ">
							<div class="ma_field panel-body">
								<?php if(isset($pf_gallery_settings['filter_position'])) $filter_position = $pf_gallery_settings['filter_position']; else $filter_position = "center"; ?>
								<select id="filter_position" name="filter_position" class="selectbox_settings form-control">
									<option value="right" <?php if($filter_position == "right") echo "selected=selected"; ?>> <?php _e('Right', 'portfolio-filter-gallery'); ?></option>
									<option value="center" <?php if($filter_position == "center") echo "selected=selected"; ?>> <?php _e('Center', 'portfolio-filter-gallery'); ?></option>
									<option value="left" <?php if($filter_position == "left") echo "selected=selected"; ?>> <?php _e('Left', 'portfolio-filter-gallery'); ?></option>
								</select>
							</div>
						</div>
					</div>
					
					
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Multi-Filters Enable', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Multi-Filters Enable', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field">
								<?php if(isset($pf_gallery_settings['multi_filters'])) $multi_filters = $pf_gallery_settings['multi_filters']; else $multi_filters = 0; ?>
								<input type="radio" name="multi_filters" id="multi_filters1" value="1" <?php if($multi_filters == 1) echo "checked=checked"; ?>>
								<label for="multi_filters1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="multi_filters" id="multi_filters2" value="0" <?php if($multi_filters == 0) echo "checked=checked"; ?>>
								<label for="multi_filters2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Multi-Filters Logic', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Multi-Filters Logic', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field">
								<?php if(isset($pf_gallery_settings['multi_filters_logic'])) $multi_filters_logic = $pf_gallery_settings['multi_filters_logic']; else $multi_filters_logic = "or"; ?>
								<input type="radio" name="multi_filters_logic" id="multi_filters_logic1" value="and" <?php if($multi_filters_logic == "and") echo "checked=checked"; ?>>
								<label for="multi_filters_logic1"><?php _e('And', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="multi_filters_logic" id="multi_filters_logic2" value="or" <?php if($multi_filters_logic == "or") echo "checked=checked"; ?>>
								<label for="multi_filters_logic2"><?php _e('Or', 'portfolio-filter-gallery'); ?></label>
								</p>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Ascending Button', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Show ascending', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field">
								<?php if(isset($pf_gallery_settings['ascending'])) $ascending = $pf_gallery_settings['ascending']; else $ascending = 0; ?>
								<input type="radio" name="ascending" id="ascending1" value="1" <?php if($ascending == 1) echo "checked=checked"; ?>>
								<label for="ascending1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="ascending" id="ascending2" value="0" <?php if($ascending == 0) echo "checked=checked"; ?>>
								<label for="ascending2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
								<?php if(isset($pf_gallery_settings['asc_txt'])) $asc_txt = $pf_gallery_settings['asc_txt']; else $asc_txt = 'Asc'; ?>
								<input type="text" class="selectbox_settings sort" id="asc_txt" name="asc_txt" value="<?php echo $asc_txt; ?>">
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Descending Button', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Show descending', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field">
								<?php if(isset($pf_gallery_settings['descending'])) $descending = $pf_gallery_settings['descending']; else $descending = 0; ?>
								<input type="radio" name="descending" id="descending1" value="1" <?php if($descending == 1) echo "checked=checked"; ?>>
								<label for="descending1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="descending" id="descending2" value="0" <?php if($descending == 0) echo "checked=checked"; ?>>
								<label for="descending2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
								<?php if(isset($pf_gallery_settings['desc_txt'])) $desc_txt = $pf_gallery_settings['desc_txt']; else $desc_txt = 'Desc'; ?>
								<input type="text" class="selectbox_settings sort" id="desc_txt" name="desc_txt" value="<?php echo $desc_txt; ?>">
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Shuffle Button', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Show descending', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field">
								<?php if(isset($pf_gallery_settings['shuffle'])) $shuffle = $pf_gallery_settings['shuffle']; else $shuffle = 0; ?>
								<input type="radio" name="shuffle" id="shuffle1" value="1" <?php if($shuffle == 1) echo "checked=checked"; ?>>
								<label for="shuffle1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="shuffle" id="shuffle2" value="0" <?php if($shuffle == 0) echo "checked=checked"; ?>>
								<label for="shuffle2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
								<?php if(isset($pf_gallery_settings['shuffle_txt'])) $shuffle_txt = $pf_gallery_settings['shuffle_txt']; else $shuffle_txt = 'Shuffle'; ?>
								<input type="text" class="selectbox_settings sort" id="shuffle_txt" name="shuffle_txt" value="<?php echo $shuffle_txt; ?>">
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-md-4">
							<div class="ma_field_discription">
								<h4><?php _e('Search Box', 'portfolio-filter-gallery'); ?></h4>
								<p><?php _e('Show descending', 'portfolio-filter-gallery'); ?></p> 
							</div>
						</div>
						<div class="col-md-8">
							<div class="ma_field panel-body">
								<p class="switch-field em_size_field">
								<?php if(isset($pf_gallery_settings['search_box'])) $search_box = $pf_gallery_settings['search_box']; else $search_box = 1; ?>
								<input type="radio" name="search_box" id="search_box1" value="1" <?php if($search_box == 1) echo "checked=checked"; ?>>
								<label for="search_box1"><?php _e('Yes', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="search_box" id="search_box2" value="0" <?php if($search_box == 0) echo "checked=checked"; ?>>
								<label for="search_box2"><?php _e('No', 'portfolio-filter-gallery'); ?></label>
								</p>
								<?php if(isset($pf_gallery_settings['search_txt'])) $search_txt = $pf_gallery_settings['search_txt']; else $search_txt = 'Search Images'; ?>
								<input type="text" class="selectbox_settings sort" id="search_txt" name="search_txt" value="<?php echo $search_txt; ?>">
							</div>
						</div>
					</div>
					<div class="">
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Filter Title Color', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Filter Title Color', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['filter_title_color'])) $filter_title_color = $pf_gallery_settings['filter_title_color']; else $filter_title_color = '#4a4747'; ?>
									<input type="text" class="form-control" id="filter_title_color" name="filter_title_color" placeholder="chose form color" value="<?php echo $filter_title_color; ?>" default-color="<?php echo $filter_title_color; ?>">
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Filter hover & active Color', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Filter hover & active Color', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['filter_bg_color'])) $filter_bg_color = $pf_gallery_settings['filter_bg_color']; else $filter_bg_color = '#dd0000'; ?>
									<input type="text" class="form-control" id="filter_bg_color" name="filter_bg_color" placeholder="chose form color" value="<?php echo $filter_bg_color; ?>" default-color="<?php echo $filter_bg_color; ?>">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="bhoechie-tab-content">
				<h1><?php _e('LightBox Configuration', 'portfolio-filter-gallery'); ?></h1>
				<hr>
				<!--Theme 1 lighbox -->
				<div class="row">
					<div class="col-md-4">
						<div class="ma_field_discription">
							<h4><?php _e('Enable Lightbox', 'portfolio-filter-gallery'); ?></h4>
							<p><?php _e('Enable or desable lightbox for gallery', 'portfolio-filter-gallery'); ?></p> 
						</div>
					</div>
					<div class="col-md-8">
						<div class="ma_field panel-body">
							<!--Theme 1 lighbox -->
							<div class="theme1_light_box">
								<?php if(isset($pf_gallery_settings['light_boxt1'])) $light_boxt1 = $pf_gallery_settings['light_boxt1']; else $light_boxt1 = 4; ?>
								<select name="light_boxt1" id="light_boxt1" class="selectbox_settings form-control">
									<option value="0" <?php if($light_boxt1 == 0) echo "selected=selected"; ?>><?php _e('None', 'portfolio-filter-gallery'); ?></option>
									<option value="4" <?php if($light_boxt1 == 4) echo "selected=selected"; ?>><?php _e('1. LD Light Box ( Lightbox works with filtered images group )', 'portfolio-filter-gallery'); ?></option>
									<option value="6" <?php if($light_boxt1 == 6) echo "selected=selected"; ?>><?php _e('2. Swipebox Light Box ( Lightbox works with filtered images group )', 'portfolio-filter-gallery'); ?></option>
									<option value="3" <?php if($light_boxt1 == 3) echo "selected=selected"; ?>><?php _e('3. Viewer Light Box ( Not work with load more )', 'portfolio-filter-gallery'); ?></option>
									<option value="5" <?php if($light_boxt1 == 5) echo "selected=selected"; ?>><?php _e('4. Bootstrap  Light Box', 'portfolio-filter-gallery'); ?></option>
								</select>
							</div>
							
							<!--Theme 2 lighbox -->
							<div class="theme2_light_box">
								<?php if(isset($pf_gallery_settings['light-box'])) $light_box = $pf_gallery_settings['light-box']; else $light_box = 4; ?>
								<select name="light-box" id="light-box" class="selectbox_settings form-control">
									<option value="0" <?php if($light_box == 0) echo "selected=selected"; ?>><?php _e('None', 'portfolio-filter-gallery'); ?></option>
									<option value="4" <?php if($light_box == 4) echo "selected=selected"; ?>><?php _e('1. LD Light Box ( Lightbox works with filtered images group )', 'portfolio-filter-gallery'); ?></option>
									<option value="6" <?php if($light_box == 6) echo "selected=selected"; ?>><?php _e('2. Swipebox Light Box ( Lightbox works with filtered images group )', 'portfolio-filter-gallery'); ?></option>
									<option value="2" <?php if($light_box == 2) echo "selected=selected"; ?>><?php _e('3. Pop Trox Light Box', 'portfolio-filter-gallery'); ?></option>
									<option value="3" <?php if($light_box == 3) echo "selected=selected"; ?>><?php _e('4. Viewer Light Box ( Not work with load more )', 'portfolio-filter-gallery'); ?></option>
									<option value="5" <?php if($light_box == 5) echo "selected=selected"; ?>><?php _e('5. Bootstrap Light Box', 'portfolio-filter-gallery'); ?></option>
								</select>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="bhoechie-tab-content">
				<h1><?php _e('Load More', 'portfolio-filter-gallery'); ?></h1>
				<hr>
				<div class="row">
					<div class="col-md-4">
						<div class="ma_field_discription">
							<h4><?php _e('Load More On Gallery', 'portfolio-filter-gallery'); ?></h4>
							<p><?php _e('Apply load more on gallery', 'portfolio-filter-gallery'); ?></p> 
						</div>
					</div>
					<div class="col-md-8">
						<div class="ma_field panel-body">
							<p class="switch-field load_scroll">
								<?php if(isset($pf_gallery_settings['pf_gallery_load_more'])) $pf_gallery_load_more = $pf_gallery_settings['pf_gallery_load_more']; else $pf_gallery_load_more = "no"; ?>
								<input type="radio" name="pf_gallery_load_more" id="pf_gallery_load_more1" value="load_button" <?php if($pf_gallery_load_more == "load_button") echo "checked=checked"; ?>>
								<label for="pf_gallery_load_more1"><?php _e('Load On Button', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="pf_gallery_load_more" id="pf_gallery_load_more2" value="load_scroll" <?php if($pf_gallery_load_more == "load_scroll") echo "checked=checked"; ?>>
								<label for="pf_gallery_load_more2"><?php _e('Load On Scroll', 'portfolio-filter-gallery'); ?></label>
								<input type="radio" name="pf_gallery_load_more" id="pf_gallery_load_more3" value="no" <?php if($pf_gallery_load_more == "no") echo "checked=checked"; ?>>
								<label for="pf_gallery_load_more3"><?php _e('None', 'portfolio-filter-gallery'); ?></label>
							</p>
						</div>
					</div>
				</div>
					<div class="load-scroll">
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Image Limit For Load More / Scroll Load', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Image limit for load more or scroll load', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['pf_limit'])) $pf_limit = $pf_gallery_settings['pf_limit']; else $pf_limit = 9; ?>
									<input type="number" name="pf_limit" id="pf_limit" value="<?php echo $pf_limit; ?>">
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Load More Button Color / Scroll Loader', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Text for load more button or scroll loader', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['load_button_color'])) $load_button_color = $pf_gallery_settings['load_button_color']; else $load_button_color = "#B2B5BC"; ?>
									<input type="text" class="form-control" id="load_button_color" name="load_button_color" placeholder="chose form color" value="<?php echo $load_button_color; ?>" default-color="<?php echo $load_button_color; ?>">
								</div>
							</div>
						</div>
					</div>
					<div class="lmb">
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Text For Load More Button', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Text for load more button', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['load_text'])) $load_text = $pf_gallery_settings['load_text']; else $load_text = "Load More"; ?>
									<input type="text" name="load_text" id="load_text" value="<?php echo $load_text; ?>">
								</div>
							</div>
						</div>
						
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Load More Icon Color', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Load more icon color', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['load_text_color'])) $load_text_color = $pf_gallery_settings['load_text_color']; else $load_text_color = "#B2B5BC"; ?>
									<input type="text" class="form-control" id="load_text_color" name="load_text_color" placeholder="chose form color" value="<?php echo $load_text_color; ?>" default-color="<?php echo $load_text_color; ?>">
								</div>
							</div>
						</div>
						<div class="row">
							<div class="col-md-4">
								<div class="ma_field_discription">
									<h4><?php _e('Text For "No More Images"', 'portfolio-filter-gallery'); ?></h4>
									<p><?php _e('Text for no more images', 'portfolio-filter-gallery'); ?></p> 
								</div>
							</div>
							<div class="col-md-8">
								<div class="ma_field panel-body">
									<?php if(isset($pf_gallery_settings['no_more_text'])) $no_more_text = $pf_gallery_settings['no_more_text']; else $no_more_text = "No More Images"; ?>
									<input type="text" name="no_more_text" id="no_more_text" value="<?php echo $no_more_text; ?>">
								</div>
							</div>
						</div>
					</div>
					
			</div>
			<div class="bhoechie-tab-content">
				<h1><?php _e('Custom CSS', 'portfolio-filter-gallery'); ?></h1>
				<hr>
				<div class="row">
					<div class="col-md-4">
						<div class="ma_field_discription">
							<h4><?php _e('Custom CSS', 'portfolio-filter-gallery'); ?></h4>
							<p><?php _e('Apply your own custom CSS. Don not use style tag', 'portfolio-filter-gallery'); ?></p> 
						</div>
					</div>
					<div class="col-md-8">
						<div class="ma_field panel-body">
							<?php if(isset($pf_gallery_settings['custom-css'])) $custom_css = $pf_gallery_settings['custom-css']; else $custom_css = ""; ?>
							<textarea class="form-control" rows="12" id="custom-css" name="custom-css"><?php echo $custom_css; ?></textarea>
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</div>
</div>	  
<?php 
	// syntax: wp_nonce_field( 'name_of_my_action', 'name_of_nonce_field' );
	wp_nonce_field( 'pfg_save_settings', 'pfg_save_nonce' );
?>
<script>

var pfg_filter_style = jQuery('#pfg_filter_style').children("option:selected").val();
	if(pfg_filter_style == 'pfg_filter_style1') {
		jQuery('.pfg_filter_style1').css("display", "block");
		jQuery('.pfg_filter_style2').css("display", "none");
		jQuery('.pfg_filter_style3').css("display", "none");
		jQuery('.pfg_filter_style4').css("display", "none");
	}
	if(pfg_filter_style == 'pfg_filter_style2') {
		jQuery('.pfg_filter_style1').css("display", "none");
		jQuery('.pfg_filter_style2').css("display", "block");
		jQuery('.pfg_filter_style3').css("display", "none");
		jQuery('.pfg_filter_style4').css("display", "none");
	}
	if(pfg_filter_style == 'pfg_filter_style3') {
		jQuery('.pfg_filter_style1').css("display", "none");
		jQuery('.pfg_filter_style2').css("display", "none");
		jQuery('.pfg_filter_style3').css("display", "block");
		jQuery('.pfg_filter_style4').css("display", "none");
	}
	if(pfg_filter_style == 'pfg_filter_style4') {
		jQuery('.pfg_filter_style1').css("display", "none");
		jQuery('.pfg_filter_style2').css("display", "none");
		jQuery('.pfg_filter_style3').css("display", "none");
		jQuery('.pfg_filter_style4').css("display", "block");
	}

var hide_filters = jQuery('[name=hide_filters]:checked').val();
	if(hide_filters == 1) {
		jQuery('.filters_section').hide();
	}
	if(hide_filters == 0) {
		jQuery('.filters_section').show(); 
	}	
var pwselectedlayout = jQuery('[name=pfg_theme]:checked').val();
if(pwselectedlayout == 'pfg_theme1') {
	jQuery('.gallery_layout_grid').addClass('gallery_layout'); 
	//hide show configuration setting according gallery layout
	jQuery('.pw_masonry_mosaic_justify_layout_config').hide();
} else {
	jQuery('.gallery_layout_grid').removeClass('gallery_layout');
	//jQuery('.pw_masonry_mosaic_justify_layout_config').show(); 			
}
	
if(pwselectedlayout == 'pfg_theme2') {
	jQuery('.gallery_layout_masonry').addClass('gallery_layout'); 
	//hide show configuration setting according gallery layout
	//jQuery('.pw_grid_layout_config').hide(); 
	jQuery('.pw_masonry_mosaic_justify_layout_config').show(); 
	
} else {
	jQuery('.gallery_layout_masonry').removeClass('gallery_layout'); 
}

var pw_load_more = jQuery('[name=pw_load_more]:checked').val();
if(pw_load_more == 'yes') {
	jQuery('.load_limit').show();
} else {
	jQuery('.load_limit').hide();
}
	
jQuery(document).ready(function() {
	jQuery("#pfg_filter_style").change(function() {
    var pfg_filter_style = jQuery(this).children("option:selected").val();
		if(pfg_filter_style == 'pfg_filter_style1') {
		jQuery('.pfg_filter_style1').css("display", "block");
		jQuery('.pfg_filter_style2').css("display", "none");
		jQuery('.pfg_filter_style3').css("display", "none");
		jQuery('.pfg_filter_style4').css("display", "none");
	}
	if(pfg_filter_style == 'pfg_filter_style2') {
		jQuery('.pfg_filter_style1').css("display", "none");
		jQuery('.pfg_filter_style2').css("display", "block");
		jQuery('.pfg_filter_style3').css("display", "none");
		jQuery('.pfg_filter_style4').css("display", "none");
	}
	if(pfg_filter_style == 'pfg_filter_style3') {
		jQuery('.pfg_filter_style1').css("display", "none");
		jQuery('.pfg_filter_style2').css("display", "none");
		jQuery('.pfg_filter_style3').css("display", "block");
		jQuery('.pfg_filter_style4').css("display", "none");
	}
	if(pfg_filter_style == 'pfg_filter_style4') {
		jQuery('.pfg_filter_style1').css("display", "none");
		jQuery('.pfg_filter_style2').css("display", "none");
		jQuery('.pfg_filter_style3').css("display", "none");
		jQuery('.pfg_filter_style4').css("display", "block");
	}
    });
	
		
	jQuery('input[type=radio][name=pfg_theme]').change(function() {
		var pwselectedlayout = jQuery('[name=pfg_theme]:checked').val();
		if(pwselectedlayout == 'pfg_theme1') {
			jQuery('.gallery_layout_grid').addClass('gallery_layout');
			//hide show configuration setting according gallery layout
			//jQuery('.pw_grid_layout_config').show(); 
			jQuery('.pw_masonry_mosaic_justify_layout_config').hide(); 
				
		} else {
			jQuery('.gallery_layout_grid').removeClass('gallery_layout'); 
		}
		
		if(pwselectedlayout == 'pfg_theme2') {
			jQuery('.gallery_layout_masonry').addClass('gallery_layout'); 
			//hide show configuration setting according gallery layout
			//jQuery('.pw_grid_layout_config').hide(); 
			jQuery('.pw_masonry_mosaic_justify_layout_config').show(); 
		} else {
			jQuery('.gallery_layout_masonry').removeClass('gallery_layout'); 
		}
			
	});
	
	jQuery('input[type=radio][name=hide_filters]').change(function() {
		var hide_filters = jQuery('[name=hide_filters]:checked').val();
		if(hide_filters == 1) {
			jQuery('.filters_section').hide();
		}
		if(hide_filters == 0) {
			jQuery('.filters_section').show(); 
		}	
	});
	
	// tab
    jQuery("div.bhoechie-tab-menu>div.list-group>a").click(function(e) {
        e.preventDefault();
        jQuery(this).siblings('a.active').removeClass("active");
        jQuery(this).addClass("active");
        var index = jQuery(this).index();
        jQuery("div.bhoechie-tab>div.bhoechie-tab-content").removeClass("active");
        jQuery("div.bhoechie-tab>div.bhoechie-tab-content").eq(index).addClass("active");
    });
	
	//load more hide show
	jQuery('input[type=radio][name=pw_load_more]').change(function() {
	var pw_load_more = jQuery('[name=pw_load_more]:checked').val();
		if(pw_load_more == 'yes') {
			jQuery('.load_limit').show();
		} else {
			jQuery('.load_limit').hide();
		}
	});
		
	jQuery('input[type=radio][name=pw_gallery_wall]').change(function() {
		var pw_gallery_wall = jQuery('[name=pw_gallery_wall]:checked').val();
		if(pw_gallery_wall == 'photo_wall') {
			jQuery('.photo_wall').addClass("tab-active");
			jQuery("div.insta_wall").removeClass("tab-active");
			jQuery("div.flickr_wall").removeClass("tab-active");
			jQuery('.gallery-content-photo-wall').css("display", "block");
			jQuery('.gallery-content-insta-wall').css("display", "none");
			jQuery('.gallery-content-flickr-wall').css("display", "none");
			// upload photos change
			jQuery('#image-gallery').css("display", "block");
			jQuery('#instaram-gallery').css("display", "none");
			jQuery('#flickr-gallery').css("display", "none");
			//instagram configuration 
			jQuery('#instagram-configration').css("display", "none");
		}
		
		if(pw_gallery_wall == 'insta_wall') {
			jQuery('.insta_wall').addClass("tab-active");
			jQuery("div.photo_wall").removeClass("tab-active");
			jQuery("div.flickr_wall").removeClass("tab-active");
			jQuery('.gallery-content-photo-wall').css("display", "none");
			jQuery('.gallery-content-insta-wall').css("display", "block");
			jQuery('.gallery-content-flickr-wall').css("display", "none");
			// upload photos change
			jQuery('#image-gallery').css("display", "none");
			jQuery('#instaram-gallery').css("display", "block");
			jQuery('#flickr-gallery').css("display", "none");
			//instagram configuration 
			jQuery('#instagram-configration').css("display", "block");
		}
		
		if(pw_gallery_wall == 'flickr_wall') {
			jQuery('.flickr_wall').addClass("tab-active");
			jQuery("div.photo_wall").removeClass("tab-active");
			jQuery("div.insta_wall").removeClass("tab-active");
			jQuery('.gallery-content-photo-wall').css("display", "none");
			jQuery('.gallery-content-insta-wall').css("display", "none");
			jQuery('.gallery-content-flickr-wall').css("display", "block");
			// upload photos change
			jQuery('#image-gallery').css("display", "none");
			jQuery('#instaram-gallery').css("display", "none");
			jQuery('#flickr-gallery').css("display", "block");
			//instagram configuration 
			jQuery('#instagram-configration').css("display", "none");
		}
	});	
	
	
});


/**========================================================================*/
	/**========================================================================*/
	/**========================================================================*/
	/**========================================================================*/
	jQuery(document).ready(function() {
	 //range slider
		var rangeSlider = function(){
		  var slider = jQuery('.range-slider'),
			  range = jQuery('.range-slider__range'),
			  value = jQuery('.range-slider__value');
			
		  slider.each(function(){

			value.each(function(){
			  var value = jQuery(this).prev().attr('value');
			  jQuery(this).html(value);
			});

			range.on('input', function(){
			  jQuery(this).next(value).html(this.value);
			});
		  });
		};
		rangeSlider();
	});
	
	
	// title size range settings.  on change range value
	function updateRange(val, id) {
		jQuery("#" + id).val(val);
		jQuery("#" + id + "_text").val(val);	  
	}
	
	//color-picker
	(function( jQuery ) {
		jQuery(function() {
			// Add Color Picker to all inputs that have 'color-field' class
			jQuery('#title_color').wpColorPicker();
			jQuery('#title_color2').wpColorPicker();
			jQuery('#title_bg_color').wpColorPicker();
			jQuery('#title_bg_color2').wpColorPicker();
			jQuery('#border_color').wpColorPicker();
			jQuery('#border_color2').wpColorPicker();
			jQuery('#filter_bg_color').wpColorPicker();
			jQuery('#filter_title_color').wpColorPicker();
			jQuery('#filter_titles_color').wpColorPicker();
			jQuery('#filter_under_line_color').wpColorPicker();
			
			jQuery('#sorting_control_color').wpColorPicker();
			jQuery('#shuffle_bg').wpColorPicker();
			jQuery('#search_border').wpColorPicker();
			jQuery('#load_button_color').wpColorPicker();	
			jQuery('#load_text_color').wpColorPicker();	
			
		});
	})( jQuery );
	
	jQuery(document).ajaxComplete(function() {
		jQuery('#title_color,#title_bg_color,#border_color,#filter_bg_color,#filter_title_color,#sorting_control_color,#shuffle_bg,#search_border,#load_button_color,#load_text_color').wpColorPicker();
	});	
	var effect_type = jQuery('input[name="image_hover_effect_type"]:checked').val();
	
	//theme 2 -----------------
	var pfg_theme = jQuery('input[name="pfg_theme"]:checked').val();
	var image_hover_effect_theme2 = jQuery('input[name="image_hover_effect_theme2"]:checked').val();
	if(pfg_theme == "pfg_theme1") {
		jQuery('.theme1_hover').show();
		jQuery('.theme2_hover').hide();
		jQuery('.theme2_filters').hide();
		jQuery('.theme1_filters').show();
		jQuery('.theme1_thumb').show();
		jQuery('.theme2_thumb').hide();
		jQuery('.theme1_light_box').show();
		jQuery('.theme2_light_box').hide();
	}
	if(pfg_theme == "pfg_theme2") {
		jQuery('.theme2_hover').show();
		jQuery('.theme1_hover').hide();
		jQuery('.theme1_filters').hide();
		jQuery('.theme2_filters').show();
		jQuery('.theme2_thumb').show();
		jQuery('.theme1_thumb').hide();
		jQuery('.theme2_light_box').show();
		jQuery('.theme1_light_box').hide();
		
		
	}
	if(image_hover_effect_theme2 == "no") {
		jQuery('.he_overlay').hide();
		jQuery('.he_2d').hide();
	}
	if(image_hover_effect_theme2 == "overlay_zoom") {
		jQuery('.he_overlay').show();
		jQuery('.he_2d').hide();
	}
	if(image_hover_effect_theme2 == "2d") {
		jQuery('.he_2d').show();
		jQuery('.he_overlay').hide();
	}
	
	//alert(effect_type);
	if(effect_type == "no") {
		jQuery('.he_one').hide();
		jQuery('.he_four').hide();
		
	}
	
	if(effect_type == "2d") {
		jQuery('.he_one').show();
		jQuery('.he_four').hide();
	
		
	}
	if(effect_type == "sg") {
		jQuery('.he_one').hide();
		jQuery('.he_four').show();
		
		
	}
	var border_setting = jQuery('input[name="border_hide"]:checked').val();
	if(border_setting == 1) {
		jQuery('.border_settings').show();
		jQuery('.border_ancore').hide();
	}
	if(border_setting == 0) {
		jQuery('.border_settings').hide();
		jQuery('.border_ancore').show();
	}
	
	var border_setting2 = jQuery('input[name="border_hide2"]:checked').val();
	if(border_setting2 == 1) {
		jQuery('.border_settings2').show();
		jQuery('.border_ancore').hide();
	}
	if(border_setting2 == 0) {
		jQuery('.border_settings2').hide();
		jQuery('.border_ancore').show();
	}

	var title_thumbnail = jQuery('input[name="title_thumb"]:checked').val();
	if(title_thumbnail == "show"){
		jQuery('.title_set').show();
		jQuery('.title_ancore').hide();
	}
	if(title_thumbnail == "hide"){
		jQuery('.title_set').hide();
		jQuery('.title_ancore').show();
	}
	var title_thumbnail2 = jQuery('input[name="title_thumb2"]:checked').val();
	if(title_thumbnail2 == "show"){
		jQuery('.title_set2').show();
		jQuery('.title_ancore').hide();
	}
	if(title_thumbnail2 == "hide"){
		jQuery('.title_set2').hide();
		jQuery('.title_ancore').show();
	}
	
	var filter_setting = jQuery('input[name="filter_setting"]:checked').val();
	if(filter_setting == "open"){
		jQuery('.filter_set').show();
		jQuery('.filt_ancore').hide();
	}
	if(filter_setting == "close"){
		jQuery('.filter_set').hide();
		jQuery('.filt_ancore').show();
	}
	
	

	var pfg_read_more = jQuery('input[name="pfg_read_more"]:checked').val();
	if(pfg_read_more == "show") {
		jQuery('.read_more_txt').show();
	}
	if(pfg_read_more == "hide") {
		jQuery('.read_more_txt').hide();
	}
	
	// on load navigation button center hide show
	var pf_gallery_load_more = jQuery('input[name="pf_gallery_load_more"]:checked').val();
	if(pf_gallery_load_more == "load_button"){
		jQuery('.lmb').show();
		jQuery('.load-scroll').show();		
	}
	if(pf_gallery_load_more == "load_scroll"){
		jQuery('.lmb').hide();
		jQuery('.load-scroll').show();		
	}
	if(pf_gallery_load_more == "no") {
		
		jQuery('.lmb').hide();		
		jQuery('.load-scroll').hide();		
	}
	
	//on change effect
	jQuery(document).ready(function() {
		jQuery('input[name="image_hover_effect_type"]').change(function(){
			var effect_type = jQuery('input[name="image_hover_effect_type"]:checked').val();
			
			//alert(effect_type);
			if(effect_type == "no") {
				jQuery('.he_one').hide();
				jQuery('.he_four').hide();
				jQuery('.he_overlay').hide();
				
			}
			
			if(effect_type == "2d") {
				jQuery('.he_one').show();
				jQuery('.he_four').hide();
				jQuery('.he_overlay').hide();
				
			}
			if(effect_type == "sg") {
				jQuery('.he_overlay').hide();
				jQuery('.he_one').hide();
				jQuery('.he_four').show();
				
			}
			
		});
		jQuery('input[name="border_hide"]').change(function(){
			var border_setting = jQuery('input[name="border_hide"]:checked').val();
			if(border_setting == 1) {
				jQuery('.border_settings').show();
				jQuery('.border_ancore').hide();
			}
			if(border_setting == 0) {
				jQuery('.border_settings').hide();
				jQuery('.border_ancore').show();
			}
		});
		
		jQuery('input[name="border_hide2"]').change(function(){
			var border_setting2 = jQuery('input[name="border_hide2"]:checked').val();
			if(border_setting2 == 1) {
				jQuery('.border_settings2').show();
				jQuery('.border_ancore').hide();
			}
			if(border_setting2 == 0) {
				jQuery('.border_settings2').hide();
				jQuery('.border_ancore').show();
			}
		});
		
		jQuery('input[name="title_thumb"]').change(function() {
			var title_thumbnail2 = jQuery('input[name="title_thumb"]:checked').val();
			if(title_thumbnail2 == "show"){
				jQuery('.title_set').show();
				jQuery('.title_ancore').hide();
			}
			if(title_thumbnail2 == "hide"){
				jQuery('.title_set').hide();
				jQuery('.title_ancore').show();
			}
		});
		
		jQuery('input[name="title_thumb2"]').change(function() {
			var title_thumbnail = jQuery('input[name="title_thumb2"]:checked').val();
			if(title_thumbnail == "show"){
				jQuery('.title_set2').show();
				jQuery('.title_ancore').hide();
			}
			if(title_thumbnail == "hide"){
				jQuery('.title_set2').hide();
				jQuery('.title_ancore').show();
			}
		});
		
		jQuery('input[name="filter_setting"]').change(function() {
			var filter_setting = jQuery('input[name="filter_setting"]:checked').val();
			if(filter_setting == "open"){
				jQuery('.filter_set').show();
				jQuery('.filt_ancore').hide();
			}
			if(filter_setting == "close"){
				jQuery('.filter_set').hide();
				jQuery('.filt_ancore').show();
			}
	
		});
		
		
		//theme 2
		jQuery('input[name="pfg_theme"]').change(function(){
			var pfg_theme = jQuery('input[name="pfg_theme"]:checked').val();
			if(pfg_theme == "pfg_theme1") {
				jQuery('.theme1_hover').show();
				jQuery('.theme2_hover').hide();
				jQuery('.theme2_filters').hide();
				jQuery('.theme1_filters').show();
				jQuery('.theme1_thumb').show();
				jQuery('.theme2_thumb').hide();
				jQuery('.theme1_light_box').show();
				jQuery('.theme2_light_box').hide();
			}
			if(pfg_theme == "pfg_theme2") {
				jQuery('.theme2_hover').show();
				jQuery('.theme1_hover').hide();
				jQuery('.theme1_filters').hide();
				jQuery('.theme2_filters').show();
				jQuery('.theme2_thumb').show();
				jQuery('.theme1_thumb').hide();
				jQuery('.theme2_light_box').show();
				jQuery('.theme1_light_box').hide();
			}
		});
		jQuery('input[name="image_hover_effect_theme2"]').change(function(){
			var image_hover_effect_theme2 = jQuery('input[name="image_hover_effect_theme2"]:checked').val();
			if(image_hover_effect_theme2 == "no") {
				jQuery('.he_overlay').hide();
				jQuery('.he_2d').hide();
			}
			if(image_hover_effect_theme2 == "overlay_zoom") {
				jQuery('.he_overlay').show();
				jQuery('.he_2d').hide();
			}
			if(image_hover_effect_theme2 == "2d") {
				jQuery('.he_2d').show();
				jQuery('.he_overlay').hide();
			}
		});
		
		jQuery('input[name="pfg_read_more"]').change(function(){
			var pfg_read_more = jQuery('input[name="pfg_read_more"]:checked').val();
			if(pfg_read_more == "show") {
				jQuery('.read_more_txt').show();
			}
			if(pfg_read_more == "hide") {
				jQuery('.read_more_txt').hide();
			}
		});
		
		jQuery('input[name="pf_gallery_load_more"]').change(function(){
			var pf_gallery_load_more = jQuery('input[name="pf_gallery_load_more"]:checked').val();
			if(pf_gallery_load_more == "load_button"){
				jQuery('.lmb').show();
				jQuery('.load-scroll').show();		
			}
			if(pf_gallery_load_more == "load_scroll"){
				jQuery('.lmb').hide();	
				jQuery('.load-scroll').show();				
			}
			if(pf_gallery_load_more == "no"){
				jQuery('.lmb').hide();		
				jQuery('.load-scroll').hide();		
			}
		});
		
		
	});
	
</script>