<?php

namespace MPHB\Emails\Booking\Admin;

use MPHB\Admin\Fields\FieldFactory;
use MPHB\Admin\Tabs;
use \MPHB\Emails;

abstract class BaseEmail extends Emails\AbstractEmail {

	/**
	 *
	 * @param array $atts
	 * @param string $atts['id'] ID of Email.
	 * @param string $atts['label'] Label.
	 * @param string $atts['description'] Optional. Email description.
	 * @param string $atts['default_subject'] Optional. Default subject of email.
	 * @param string $atts['default_header_text'] Optional. Default text in header.
	 * @param Emails\Templaters\EmailTemplaterr $templater
	 */
	public function __construct( $atts, Emails\Templaters\EmailTemplater $templater ){
		parent::__construct( $atts, $templater );
		add_action( 'mphb_generate_settings_admin_emails', array( $this, 'generateSettingsFields' ) );
	}

	/**
	 * @param Tabs\SettingsTab $tab
	 */
	public function generateSettingsFields( Tabs\SettingsTab $tab ) {
		parent::generateSettingsFields( $tab ); // TODO: Change the autogenerated stub
		$groups =$tab->getGroups();
		end($groups)->addField(FieldFactory::create( 'mphb_email_' . $this->id . '_recipients', array(
			'type'			 => 'text',
			'label'			 => __( 'Recipients', 'motopress-hotel-booking' ),
			'placeholder'	 => MPHB()->settings()->emails()->getAdminEmail(),
			'size'			 => 'large',
			'description' => __( 'You can use multiple comma-separated emails', 'motopress-hotel-booking' ),
		)));
	}


	/**
	 *
	 * @return string
	 */
	protected function getReceiver(){
		$recipients = $this->getOption( 'recipients' );

		if ( empty( $recipients ) ) {
			$recipients = MPHB()->settings()->emails()->getHotelAdminEmail();
		}

		return $recipients;
	}

	/**
	 *
	 * @return bool
	 */
	public function send(){

		do_action( '_mphb_translate_admin_email_before_send', $this->booking );

		$isSended = parent::send();

		do_action( '_mphb_translate_admin_email_after_send', $this->booking );

		return $isSended;
	}

	/**
	 *
	 * @param bool $isSended
	 */
	protected function log( $isSended ){
        $author = $this->getAuthor();

		if ( $isSended ) {
			$this->booking->addLog( sprintf( __( '"%s" mail was sent to admin.', 'motopress-hotel-booking' ), $this->label ), $author );
		} else {
			$this->booking->addLog( sprintf( __( '"%s" mail sending to admin is failed.', 'motopress-hotel-booking' ), $this->label ), $author );
		}
	}

}
